/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.tubesock;

import com.firebase.tubesock.WebSocket;
import com.firebase.tubesock.WebSocketException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

class WebSocketWriter
extends Thread {
    private BlockingQueue<ByteBuffer> pendingBuffers;
    private final Random random = new Random();
    private volatile boolean stop = false;
    private boolean closeSent = false;
    private WebSocket websocket;
    private WritableByteChannel channel;

    WebSocketWriter(OutputStream output, WebSocket websocket, String threadBaseName) {
        this.setName(threadBaseName + "Writer");
        this.websocket = websocket;
        this.channel = Channels.newChannel(output);
        this.pendingBuffers = new LinkedBlockingQueue<ByteBuffer>();
    }

    private ByteBuffer frameInBuffer(byte opcode, boolean masking, byte[] data) throws IOException {
        int length_field;
        int length;
        int headerLength = 2;
        if (masking) {
            headerLength += 4;
        }
        if ((length = data.length) >= 126) {
            headerLength = length <= 65535 ? (headerLength += 2) : (headerLength += 8);
        }
        ByteBuffer frame = ByteBuffer.allocate(data.length + headerLength);
        int fin = -128;
        byte startByte = (byte)(fin | opcode);
        frame.put(startByte);
        if (length < 126) {
            if (masking) {
                length = 0x80 | length;
            }
            frame.put((byte)length);
        } else if (length <= 65535) {
            length_field = 126;
            if (masking) {
                length_field = 0x80 | length_field;
            }
            frame.put((byte)length_field);
            frame.putShort((short)length);
        } else {
            length_field = 127;
            if (masking) {
                length_field = 0x80 | length_field;
            }
            frame.put((byte)length_field);
            frame.putInt(0);
            frame.putInt(length);
        }
        if (masking) {
            byte[] mask = this.generateMask();
            frame.put(mask);
            for (int i = 0; i < data.length; ++i) {
                frame.put((byte)(data[i] ^ mask[i % 4]));
            }
        }
        frame.flip();
        return frame;
    }

    private byte[] generateMask() {
        byte[] mask = new byte[4];
        this.random.nextBytes(mask);
        return mask;
    }

    synchronized void send(byte opcode, boolean masking, byte[] data) throws IOException {
        ByteBuffer frame = this.frameInBuffer(opcode, masking, data);
        if (this.stop && (this.closeSent || opcode != 8)) {
            throw new WebSocketException("Shouldn't be sending");
        }
        if (opcode == 8) {
            this.closeSent = true;
        }
        this.pendingBuffers.add(frame);
    }

    public void run() {
        try {
            while (!this.stop && !Thread.interrupted()) {
                this.writeMessage();
            }
            for (int i = 0; i < this.pendingBuffers.size(); ++i) {
                this.writeMessage();
            }
        }
        catch (IOException e) {
            this.handleError(new WebSocketException("IO Exception", e));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void writeMessage() throws InterruptedException, IOException {
        ByteBuffer msg = this.pendingBuffers.take();
        this.channel.write(msg);
    }

    void stopIt() {
        this.stop = true;
    }

    private void handleError(WebSocketException e) {
        this.websocket.handleReceiverError(e);
    }
}

