/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Application;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.remote.SingleProviderSignInHandler;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseAuth;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnonymousSignInHandler
extends SingleProviderSignInHandler<FlowParameters> {
    @VisibleForTesting
    public FirebaseAuth mAuth;

    public AnonymousSignInHandler(Application application) {
        super(application, "anonymous");
    }

    @Override
    protected void onCreate() {
        this.mAuth = this.getAuth();
    }

    @Override
    public void startSignIn(@NonNull FirebaseAuth auth, @NonNull HelperActivityBase activity, @NonNull String providerId) {
        this.setResult(Resource.forLoading());
        this.mAuth.signInAnonymously().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

            public void onSuccess(AuthResult result) {
                AnonymousSignInHandler.this.setResult(Resource.forSuccess(AnonymousSignInHandler.this.initResponse(result.getAdditionalUserInfo().isNewUser())));
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                AnonymousSignInHandler.this.setResult(Resource.forFailure(e));
            }
        });
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    }

    private IdpResponse initResponse(boolean isNewUser) {
        return new IdpResponse.Builder(new User.Builder("anonymous", null).build()).setNewUser(isNewUser).build();
    }

    private FirebaseAuth getAuth() {
        return AuthUI.getInstance(((FlowParameters)this.getArguments()).appName).getAuth();
    }
}

