/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.util.data.TaskFailureLogger;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.auth.UserProfileChangeRequest;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ProfileMerger
implements Continuation<AuthResult, Task<AuthResult>> {
    private static final String TAG = "ProfileMerger";
    private final IdpResponse mResponse;

    public ProfileMerger(IdpResponse response) {
        this.mResponse = response;
    }

    public Task<AuthResult> then(@NonNull Task<AuthResult> task) {
        final AuthResult authResult = (AuthResult)task.getResult();
        FirebaseUser firebaseUser = authResult.getUser();
        String name = firebaseUser.getDisplayName();
        Uri photoUri = firebaseUser.getPhotoUrl();
        if (!TextUtils.isEmpty((CharSequence)name) && photoUri != null) {
            return Tasks.forResult((Object)authResult);
        }
        User user = this.mResponse.getUser();
        if (TextUtils.isEmpty((CharSequence)name)) {
            name = user.getName();
        }
        if (photoUri == null) {
            photoUri = user.getPhotoUri();
        }
        return firebaseUser.updateProfile(new UserProfileChangeRequest.Builder().setDisplayName(name).setPhotoUri(photoUri).build()).addOnFailureListener((OnFailureListener)new TaskFailureLogger(TAG, "Error updating profile")).continueWithTask((Continuation)new Continuation<Void, Task<AuthResult>>(){

            public Task<AuthResult> then(@NonNull Task<Void> task) {
                return Tasks.forResult((Object)authResult);
            }
        });
    }
}

