/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.app.Activity;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.PhoneNumber;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.ui.phone.CheckPhoneHandler;
import com.firebase.ui.auth.ui.phone.CountryListSpinner;
import com.firebase.ui.auth.ui.phone.PhoneNumberVerificationHandler;
import com.firebase.ui.auth.util.data.PhoneNumberUtils;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.ui.ImeHelper;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.google.android.material.textfield.TextInputLayout;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class CheckPhoneNumberFragment
extends FragmentBase
implements View.OnClickListener {
    public static final String TAG = "VerifyPhoneFragment";
    private PhoneNumberVerificationHandler mVerificationHandler;
    private CheckPhoneHandler mCheckPhoneHandler;
    private boolean mCalled;
    private ProgressBar mProgressBar;
    private Button mSubmitButton;
    private CountryListSpinner mCountryListSpinner;
    private TextInputLayout mPhoneInputLayout;
    private EditText mPhoneEditText;
    private TextView mSmsTermsText;
    private TextView mFooterText;

    public static CheckPhoneNumberFragment newInstance(Bundle params) {
        CheckPhoneNumberFragment fragment = new CheckPhoneNumberFragment();
        Bundle args = new Bundle();
        args.putBundle("extra_params", params);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mVerificationHandler = (PhoneNumberVerificationHandler)new ViewModelProvider((ViewModelStoreOwner)this.requireActivity()).get(PhoneNumberVerificationHandler.class);
        this.mCheckPhoneHandler = (CheckPhoneHandler)new ViewModelProvider((ViewModelStoreOwner)this).get(CheckPhoneHandler.class);
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fui_phone_layout, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mProgressBar = (ProgressBar)view.findViewById(R.id.top_progress_bar);
        this.mSubmitButton = (Button)view.findViewById(R.id.send_code);
        this.mCountryListSpinner = (CountryListSpinner)view.findViewById(R.id.country_list);
        this.mPhoneInputLayout = (TextInputLayout)view.findViewById(R.id.phone_layout);
        this.mPhoneEditText = (EditText)view.findViewById(R.id.phone_number);
        this.mSmsTermsText = (TextView)view.findViewById(R.id.send_sms_tos);
        this.mFooterText = (TextView)view.findViewById(R.id.email_footer_tos_and_pp_text);
        this.mSmsTermsText.setText((CharSequence)this.getString(R.string.fui_sms_terms_of_service, new Object[]{this.getString(R.string.fui_verify_phone_number)}));
        if (Build.VERSION.SDK_INT >= 26 && this.getFlowParams().enableHints) {
            this.mPhoneEditText.setImportantForAutofill(2);
        }
        this.requireActivity().setTitle((CharSequence)this.getString(R.string.fui_verify_phone_number_title));
        ImeHelper.setImeOnDoneListener(this.mPhoneEditText, new ImeHelper.DonePressedListener(){

            @Override
            public void onDonePressed() {
                CheckPhoneNumberFragment.this.onNext();
            }
        });
        this.mSubmitButton.setOnClickListener((View.OnClickListener)this);
        this.setupPrivacyDisclosures();
        this.setupCountrySpinner();
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        this.mCheckPhoneHandler.getOperation().observe(this.getViewLifecycleOwner(), (Observer)new ResourceObserver<PhoneNumber>((FragmentBase)this){

            @Override
            protected void onSuccess(@NonNull PhoneNumber number) {
                CheckPhoneNumberFragment.this.start(number);
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
            }
        });
        if (savedInstanceState != null || this.mCalled) {
            return;
        }
        this.mCalled = true;
        this.setDefaultCountryForSpinner();
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        this.mCheckPhoneHandler.onActivityResult(requestCode, resultCode, data);
    }

    public void onClick(View v) {
        this.onNext();
    }

    private void start(PhoneNumber number) {
        if (!PhoneNumber.isValid(number)) {
            this.mPhoneInputLayout.setError((CharSequence)this.getString(R.string.fui_invalid_phone_number));
            return;
        }
        this.mPhoneEditText.setText((CharSequence)number.getPhoneNumber());
        this.mPhoneEditText.setSelection(number.getPhoneNumber().length());
        String iso = number.getCountryIso();
        if (PhoneNumber.isCountryValid(number) && this.mCountryListSpinner.isValidIso(iso)) {
            this.setCountryCode(number);
            this.onNext();
        }
    }

    private void onNext() {
        String phoneNumber = this.getPseudoValidPhoneNumber();
        if (phoneNumber == null) {
            this.mPhoneInputLayout.setError((CharSequence)this.getString(R.string.fui_invalid_phone_number));
        } else {
            this.mVerificationHandler.verifyPhoneNumber((Activity)this.requireActivity(), phoneNumber, false);
        }
    }

    @Nullable
    private String getPseudoValidPhoneNumber() {
        String everythingElse = this.mPhoneEditText.getText().toString();
        if (TextUtils.isEmpty((CharSequence)everythingElse)) {
            return null;
        }
        return PhoneNumberUtils.format(everythingElse, this.mCountryListSpinner.getSelectedCountryInfo());
    }

    private void setupPrivacyDisclosures() {
        boolean termsAndPrivacyUrlsProvided;
        FlowParameters params = this.getFlowParams();
        boolean bl = termsAndPrivacyUrlsProvided = params.isTermsOfServiceUrlProvided() && params.isPrivacyPolicyUrlProvided();
        if (!params.shouldShowProviderChoice() && termsAndPrivacyUrlsProvided) {
            PrivacyDisclosureUtils.setupTermsOfServiceAndPrivacyPolicySmsText(this.requireContext(), params, this.mSmsTermsText);
        } else {
            PrivacyDisclosureUtils.setupTermsOfServiceFooter(this.requireContext(), params, this.mFooterText);
            String verifyText = this.getString(R.string.fui_verify_phone_number);
            this.mSmsTermsText.setText((CharSequence)this.getString(R.string.fui_sms_terms_of_service, new Object[]{verifyText}));
        }
    }

    private void setCountryCode(PhoneNumber number) {
        this.mCountryListSpinner.setSelectedForCountry(new Locale("", number.getCountryIso()), number.getCountryCode());
    }

    private void setupCountrySpinner() {
        Bundle params = this.getArguments().getBundle("extra_params");
        this.mCountryListSpinner.init(params);
        this.mCountryListSpinner.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CheckPhoneNumberFragment.this.mPhoneInputLayout.setError(null);
            }
        });
    }

    private void setDefaultCountryForSpinner() {
        Bundle params = this.getArguments().getBundle("extra_params");
        String phone = null;
        String countryIso = null;
        String nationalNumber = null;
        if (params != null) {
            phone = params.getString("extra_phone_number");
            countryIso = params.getString("extra_country_iso");
            nationalNumber = params.getString("extra_national_number");
        }
        if (!TextUtils.isEmpty(phone)) {
            this.start(PhoneNumberUtils.getPhoneNumber(phone));
        } else if (!TextUtils.isEmpty(countryIso) && !TextUtils.isEmpty(nationalNumber)) {
            this.start(PhoneNumberUtils.getPhoneNumber(countryIso, nationalNumber));
        } else if (!TextUtils.isEmpty((CharSequence)countryIso)) {
            this.setCountryCode(new PhoneNumber("", countryIso, String.valueOf(PhoneNumberUtils.getCountryCode(countryIso))));
        } else if (this.getFlowParams().enableHints) {
            this.mCheckPhoneHandler.fetchCredential();
        }
    }

    @Override
    public void showProgress(int message) {
        this.mSubmitButton.setEnabled(false);
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mSubmitButton.setEnabled(true);
        this.mProgressBar.setVisibility(4);
    }
}

