/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.content.Context;
import android.widget.ArrayAdapter;
import android.widget.SectionIndexer;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.CountryInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

final class CountryListAdapter
extends ArrayAdapter<CountryInfo>
implements SectionIndexer {
    private final HashMap<String, Integer> alphaIndex = new LinkedHashMap<String, Integer>();
    private final HashMap<String, Integer> countryPosition = new LinkedHashMap<String, Integer>();
    private String[] sections;

    public CountryListAdapter(Context context) {
        super(context, R.layout.fui_dgts_country_row, 16908308);
    }

    public void setData(List<CountryInfo> countries) {
        int index = 0;
        for (CountryInfo countryInfo : countries) {
            String key = countryInfo.getLocale().getDisplayCountry().substring(0, 1).toUpperCase(Locale.getDefault());
            if (!this.alphaIndex.containsKey(key)) {
                this.alphaIndex.put(key, index);
            }
            this.countryPosition.put(countryInfo.getLocale().getDisplayCountry(), index);
            ++index;
            this.add(countryInfo);
        }
        this.sections = new String[this.alphaIndex.size()];
        this.alphaIndex.keySet().toArray(this.sections);
        this.notifyDataSetChanged();
    }

    public int getCount() {
        return this.countryPosition.size();
    }

    public Object[] getSections() {
        return this.sections;
    }

    public int getPositionForSection(int index) {
        if (this.sections == null) {
            return 0;
        }
        if (index <= 0) {
            return 0;
        }
        if (index >= this.sections.length) {
            index = this.sections.length - 1;
        }
        return this.alphaIndex.get(this.sections[index]);
    }

    public int getSectionForPosition(int position) {
        if (this.sections == null) {
            return 0;
        }
        for (int i = 0; i < this.sections.length; ++i) {
            if (this.getPositionForSection(i) <= position) continue;
            return i - 1;
        }
        return 0;
    }

    public int getPositionForCountry(String country) {
        Integer position = this.countryPosition.get(country);
        return position == null ? 0 : position;
    }
}

