/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.PhoneNumberVerificationRequiredException;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.ui.AppCompatBase;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.phone.CheckPhoneNumberFragment;
import com.firebase.ui.auth.ui.phone.PhoneNumberVerificationHandler;
import com.firebase.ui.auth.ui.phone.PhoneVerification;
import com.firebase.ui.auth.ui.phone.SubmitConfirmationCodeFragment;
import com.firebase.ui.auth.util.FirebaseAuthError;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.phone.PhoneProviderResponseHandler;
import com.google.android.material.textfield.TextInputLayout;
import com.google.firebase.auth.FirebaseAuthException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PhoneActivity
extends AppCompatBase {
    private PhoneNumberVerificationHandler mPhoneVerifier;

    public static Intent createIntent(Context context, FlowParameters params, Bundle args) {
        return PhoneActivity.createBaseIntent(context, PhoneActivity.class, params).putExtra("extra_params", args);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fui_activity_register_phone);
        final PhoneProviderResponseHandler handler = (PhoneProviderResponseHandler)new ViewModelProvider((ViewModelStoreOwner)this).get(PhoneProviderResponseHandler.class);
        handler.init(this.getFlowParams());
        handler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this, R.string.fui_progress_dialog_signing_in){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                PhoneActivity.this.startSaveCredentials(handler.getCurrentUser(), response, null);
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                PhoneActivity.this.handleError(e);
            }
        });
        this.mPhoneVerifier = (PhoneNumberVerificationHandler)new ViewModelProvider((ViewModelStoreOwner)this).get(PhoneNumberVerificationHandler.class);
        this.mPhoneVerifier.init(this.getFlowParams());
        this.mPhoneVerifier.onRestoreInstanceState(savedInstanceState);
        this.mPhoneVerifier.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<PhoneVerification>((HelperActivityBase)this, R.string.fui_verifying){

            @Override
            protected void onSuccess(@NonNull PhoneVerification verification) {
                if (verification.isAutoVerified()) {
                    Toast.makeText((Context)PhoneActivity.this, (int)R.string.fui_auto_verified, (int)1).show();
                    FragmentManager manager = PhoneActivity.this.getSupportFragmentManager();
                    if (manager.findFragmentByTag("SubmitConfirmationCodeFragment") != null) {
                        manager.popBackStack();
                    }
                }
                handler.startSignIn(verification.getCredential(), new IdpResponse.Builder(new User.Builder("phone", null).setPhoneNumber(verification.getNumber()).build()).build());
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof PhoneNumberVerificationRequiredException) {
                    if (PhoneActivity.this.getSupportFragmentManager().findFragmentByTag("SubmitConfirmationCodeFragment") == null) {
                        PhoneActivity.this.showSubmitCodeFragment(((PhoneNumberVerificationRequiredException)e).getPhoneNumber());
                    }
                    PhoneActivity.this.handleError(null);
                } else {
                    PhoneActivity.this.handleError(e);
                }
            }
        });
        if (savedInstanceState != null) {
            return;
        }
        Bundle params = this.getIntent().getExtras().getBundle("extra_params");
        CheckPhoneNumberFragment fragment = CheckPhoneNumberFragment.newInstance(params);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment_phone, (Fragment)fragment, "VerifyPhoneFragment").disallowAddToBackStack().commit();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mPhoneVerifier.onSaveInstanceState(outState);
    }

    public void onBackPressed() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() > 0) {
            this.getSupportFragmentManager().popBackStack();
        } else {
            super.onBackPressed();
        }
    }

    private void handleError(@Nullable Exception e) {
        TextInputLayout errorView = this.getErrorView();
        if (errorView == null) {
            return;
        }
        if (e instanceof FirebaseAuthAnonymousUpgradeException) {
            IdpResponse response = ((FirebaseAuthAnonymousUpgradeException)e).getResponse();
            this.finish(5, response.toIntent());
        } else if (e instanceof FirebaseAuthException) {
            FirebaseAuthError error = FirebaseAuthError.fromException((FirebaseAuthException)e);
            if (error == FirebaseAuthError.ERROR_USER_DISABLED) {
                IdpResponse response = IdpResponse.from(new FirebaseUiException(12));
                this.finish(0, response.toIntent());
                return;
            }
            errorView.setError((CharSequence)this.getErrorMessage(error));
        } else if (e != null) {
            errorView.setError((CharSequence)e.getLocalizedMessage());
        } else {
            errorView.setError(null);
        }
    }

    @Nullable
    private TextInputLayout getErrorView() {
        CheckPhoneNumberFragment checkFragment = (CheckPhoneNumberFragment)this.getSupportFragmentManager().findFragmentByTag("VerifyPhoneFragment");
        SubmitConfirmationCodeFragment submitFragment = (SubmitConfirmationCodeFragment)this.getSupportFragmentManager().findFragmentByTag("SubmitConfirmationCodeFragment");
        if (checkFragment != null && checkFragment.getView() != null) {
            return (TextInputLayout)checkFragment.getView().findViewById(R.id.phone_layout);
        }
        if (submitFragment != null && submitFragment.getView() != null) {
            return (TextInputLayout)submitFragment.getView().findViewById(R.id.confirmation_code_layout);
        }
        return null;
    }

    private String getErrorMessage(FirebaseAuthError error) {
        switch (error) {
            case ERROR_INVALID_PHONE_NUMBER: {
                return this.getString(R.string.fui_invalid_phone_number);
            }
            case ERROR_TOO_MANY_REQUESTS: {
                return this.getString(R.string.fui_error_too_many_attempts);
            }
            case ERROR_QUOTA_EXCEEDED: {
                return this.getString(R.string.fui_error_quota_exceeded);
            }
            case ERROR_INVALID_VERIFICATION_CODE: {
                return this.getString(R.string.fui_incorrect_code_dialog_body);
            }
            case ERROR_SESSION_EXPIRED: {
                return this.getString(R.string.fui_error_session_expired);
            }
        }
        return error.getDescription();
    }

    private void showSubmitCodeFragment(String number) {
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment_phone, (Fragment)SubmitConfirmationCodeFragment.newInstance(number), "SubmitConfirmationCodeFragment").addToBackStack(null).commit();
    }

    @Override
    public void showProgress(int message) {
        this.getActiveFragment().showProgress(message);
    }

    @Override
    public void hideProgress() {
        this.getActiveFragment().hideProgress();
    }

    @NonNull
    private FragmentBase getActiveFragment() {
        FragmentBase fragment = (CheckPhoneNumberFragment)this.getSupportFragmentManager().findFragmentByTag("VerifyPhoneFragment");
        if (fragment == null || fragment.getView() == null) {
            fragment = (SubmitConfirmationCodeFragment)this.getSupportFragmentManager().findFragmentByTag("SubmitConfirmationCodeFragment");
        }
        if (fragment == null || fragment.getView() == null) {
            throw new IllegalStateException("No fragments added");
        }
        return fragment;
    }
}

