/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.email;

import android.app.Application;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.firebase.ui.auth.util.data.ContinueUrlBuilder;
import com.firebase.ui.auth.util.data.EmailLinkPersistenceManager;
import com.firebase.ui.auth.util.data.SessionUtils;
import com.firebase.ui.auth.viewmodel.AuthViewModelBase;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.auth.ActionCodeSettings;

public class EmailLinkSendEmailHandler
extends AuthViewModelBase<String> {
    private static final int SESSION_ID_LENGTH = 10;

    public EmailLinkSendEmailHandler(Application application) {
        super(application);
    }

    public void sendSignInLinkToEmail(final @NonNull String email, @NonNull ActionCodeSettings actionCodeSettings, @Nullable IdpResponse idpResponseForLinking, boolean forceSameDevice) {
        if (this.getAuth() == null) {
            return;
        }
        this.setResult(Resource.forLoading());
        final String anonymousUserId = AuthOperationManager.getInstance().canUpgradeAnonymous(this.getAuth(), (FlowParameters)this.getArguments()) ? this.getAuth().getCurrentUser().getUid() : null;
        final String sessionId = SessionUtils.generateRandomAlphaNumericString(10);
        ActionCodeSettings mutatedSettings = this.addSessionInfoToActionCodeSettings(actionCodeSettings, sessionId, anonymousUserId, idpResponseForLinking, forceSameDevice);
        this.getAuth().sendSignInLinkToEmail(email, mutatedSettings).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                if (task.isSuccessful()) {
                    EmailLinkPersistenceManager.getInstance().saveEmail((Context)EmailLinkSendEmailHandler.this.getApplication(), email, sessionId, anonymousUserId);
                    EmailLinkSendEmailHandler.this.setResult(Resource.forSuccess(email));
                } else {
                    EmailLinkSendEmailHandler.this.setResult(Resource.forFailure(task.getException()));
                }
            }
        });
    }

    private ActionCodeSettings addSessionInfoToActionCodeSettings(@NonNull ActionCodeSettings actionCodeSettings, @NonNull String sessionId, @NonNull String anonymousUserId, @Nullable IdpResponse response, boolean forceSameDevice) {
        String continueUrl = actionCodeSettings.getUrl();
        ContinueUrlBuilder continueUrlBuilder = new ContinueUrlBuilder(continueUrl);
        continueUrlBuilder.appendSessionId(sessionId);
        continueUrlBuilder.appendAnonymousUserId(anonymousUserId);
        continueUrlBuilder.appendForceSameDeviceBit(forceSameDevice);
        if (response != null) {
            continueUrlBuilder.appendProviderId(response.getProviderType());
        }
        return ActionCodeSettings.newBuilder().setUrl(continueUrlBuilder.build()).setHandleCodeInApp(true).setAndroidPackageName(actionCodeSettings.getAndroidPackageName(), actionCodeSettings.getAndroidInstallApp(), actionCodeSettings.getAndroidMinimumVersion()).setIOSBundleId(actionCodeSettings.getIOSBundle()).build();
    }
}

