/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.idp;

import android.app.Application;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.firebase.ui.auth.util.data.ProviderUtils;
import com.firebase.ui.auth.viewmodel.SignInViewModelBase;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class LinkingSocialProviderResponseHandler
extends SignInViewModelBase {
    private AuthCredential mRequestedSignInCredential;
    private String mEmail;

    public LinkingSocialProviderResponseHandler(Application application) {
        super(application);
    }

    public void setRequestedSignInCredentialForEmail(@Nullable AuthCredential credential, @Nullable String email) {
        this.mRequestedSignInCredential = credential;
        this.mEmail = email;
    }

    public void startSignIn(final @NonNull IdpResponse response) {
        if (!response.isSuccessful()) {
            this.setResult(Resource.forFailure(response.getError()));
            return;
        }
        if (this.isInvalidProvider(response.getProviderType())) {
            throw new IllegalStateException("This handler cannot be used to link email or phone providers.");
        }
        if (this.mEmail != null && !this.mEmail.equals(response.getEmail())) {
            this.setResult(Resource.forFailure(new FirebaseUiException(6)));
            return;
        }
        this.setResult(Resource.forLoading());
        if (this.isGenericIdpLinkingFlow(response.getProviderType())) {
            this.getAuth().getCurrentUser().linkWithCredential(this.mRequestedSignInCredential).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

                public void onSuccess(AuthResult authResult) {
                    LinkingSocialProviderResponseHandler.this.handleSuccess(response, authResult);
                }
            }).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e) {
                    Resource.forFailure(e);
                }
            });
            return;
        }
        AuthOperationManager authOperationManager = AuthOperationManager.getInstance();
        final AuthCredential credential = ProviderUtils.getAuthCredential(response);
        if (authOperationManager.canUpgradeAnonymous(this.getAuth(), (FlowParameters)this.getArguments())) {
            if (this.mRequestedSignInCredential == null) {
                this.handleMergeFailure(credential);
            } else {
                authOperationManager.safeLink(credential, this.mRequestedSignInCredential, (FlowParameters)this.getArguments()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<AuthResult>(){

                    public void onSuccess(AuthResult result) {
                        LinkingSocialProviderResponseHandler.this.handleMergeFailure(credential);
                    }
                }).addOnFailureListener(new OnFailureListener(){

                    public void onFailure(@NonNull Exception e) {
                        LinkingSocialProviderResponseHandler.this.setResult(Resource.forFailure(e));
                    }
                });
            }
        } else {
            this.getAuth().signInWithCredential(credential).continueWithTask((Continuation)new Continuation<AuthResult, Task<AuthResult>>(){

                public Task<AuthResult> then(@NonNull Task<AuthResult> task) {
                    final AuthResult result = (AuthResult)task.getResult();
                    if (LinkingSocialProviderResponseHandler.this.mRequestedSignInCredential == null) {
                        return Tasks.forResult((Object)result);
                    }
                    return result.getUser().linkWithCredential(LinkingSocialProviderResponseHandler.this.mRequestedSignInCredential).continueWith((Continuation)new Continuation<AuthResult, AuthResult>(){

                        public AuthResult then(@NonNull Task<AuthResult> task) {
                            if (task.isSuccessful()) {
                                return (AuthResult)task.getResult();
                            }
                            return result;
                        }
                    });
                }
            }).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<AuthResult>(){

                public void onComplete(@NonNull Task<AuthResult> task) {
                    if (task.isSuccessful()) {
                        LinkingSocialProviderResponseHandler.this.handleSuccess(response, (AuthResult)task.getResult());
                    } else {
                        LinkingSocialProviderResponseHandler.this.setResult(Resource.forFailure(task.getException()));
                    }
                }
            });
        }
    }

    public boolean hasCredentialForLinking() {
        return this.mRequestedSignInCredential != null;
    }

    private boolean isGenericIdpLinkingFlow(@NonNull String providerId) {
        return AuthUI.SUPPORTED_OAUTH_PROVIDERS.contains(providerId) && this.mRequestedSignInCredential != null && this.getAuth().getCurrentUser() != null && !this.getAuth().getCurrentUser().isAnonymous();
    }

    private boolean isInvalidProvider(@NonNull String provider) {
        return TextUtils.equals((CharSequence)provider, (CharSequence)"password") || TextUtils.equals((CharSequence)provider, (CharSequence)"phone");
    }
}

