/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.model;

import android.text.TextUtils;
import androidx.annotation.RestrictTo;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class PhoneNumber {
    private static final PhoneNumber EMPTY_PHONE_NUMBER = new PhoneNumber("", "", "");
    private final String mPhoneNumber;
    private final String mCountryIso;
    private final String mCountryCode;

    public PhoneNumber(String phoneNumber, String countryIso, String countryCode) {
        this.mPhoneNumber = phoneNumber;
        this.mCountryIso = countryIso;
        this.mCountryCode = countryCode;
    }

    public static PhoneNumber emptyPhone() {
        return EMPTY_PHONE_NUMBER;
    }

    public static boolean isValid(PhoneNumber phoneNumber) {
        return phoneNumber != null && !EMPTY_PHONE_NUMBER.equals(phoneNumber) && !TextUtils.isEmpty((CharSequence)phoneNumber.getPhoneNumber()) && !TextUtils.isEmpty((CharSequence)phoneNumber.getCountryCode()) && !TextUtils.isEmpty((CharSequence)phoneNumber.getCountryIso());
    }

    public static boolean isCountryValid(PhoneNumber phoneNumber) {
        return phoneNumber != null && !EMPTY_PHONE_NUMBER.equals(phoneNumber) && !TextUtils.isEmpty((CharSequence)phoneNumber.getCountryCode()) && !TextUtils.isEmpty((CharSequence)phoneNumber.getCountryIso());
    }

    public String getCountryCode() {
        return this.mCountryCode;
    }

    public String getPhoneNumber() {
        return this.mPhoneNumber;
    }

    public String getCountryIso() {
        return this.mCountryIso;
    }
}

