/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.remote;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.data.remote.SingleProviderSignInHandler;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.phone.PhoneActivity;
import com.google.firebase.auth.FirebaseAuth;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PhoneSignInHandler
extends SingleProviderSignInHandler<AuthUI.IdpConfig> {
    public PhoneSignInHandler(Application application) {
        super(application, "phone");
    }

    @Override
    public void startSignIn(@NonNull FirebaseAuth auth, @NonNull HelperActivityBase activity, @NonNull String providerId) {
        activity.startActivityForResult(PhoneActivity.createIntent((Context)activity, activity.getFlowParams(), ((AuthUI.IdpConfig)this.getArguments()).getParams()), 107);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (requestCode == 107) {
            IdpResponse response = IdpResponse.fromResultIntent(data);
            if (response == null) {
                this.setResult(Resource.forFailure(new UserCancellationException()));
            } else {
                this.setResult(Resource.forSuccess(response));
            }
        }
    }
}

