/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.email;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.app.AlertDialog;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.ui.AppCompatBase;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.util.data.PrivacyDisclosureUtils;
import com.firebase.ui.auth.util.ui.ImeHelper;
import com.firebase.ui.auth.util.ui.fieldvalidators.EmailFieldValidator;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.firebase.ui.auth.viewmodel.email.RecoverPasswordHandler;
import com.google.android.material.textfield.TextInputLayout;
import com.google.firebase.auth.ActionCodeSettings;
import com.google.firebase.auth.FirebaseAuthInvalidCredentialsException;
import com.google.firebase.auth.FirebaseAuthInvalidUserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class RecoverPasswordActivity
extends AppCompatBase
implements View.OnClickListener,
ImeHelper.DonePressedListener {
    private RecoverPasswordHandler mHandler;
    private ProgressBar mProgressBar;
    private Button mSubmitButton;
    private TextInputLayout mEmailInputLayout;
    private EditText mEmailEditText;
    private EmailFieldValidator mEmailFieldValidator;

    public static Intent createIntent(Context context, FlowParameters params, String email) {
        return RecoverPasswordActivity.createBaseIntent(context, RecoverPasswordActivity.class, params).putExtra("extra_email", email);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.fui_forgot_password_layout);
        this.mHandler = (RecoverPasswordHandler)new ViewModelProvider((ViewModelStoreOwner)this).get(RecoverPasswordHandler.class);
        this.mHandler.init(this.getFlowParams());
        this.mHandler.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<String>((HelperActivityBase)this, R.string.fui_progress_dialog_sending){

            @Override
            protected void onSuccess(@NonNull String email) {
                RecoverPasswordActivity.this.mEmailInputLayout.setError(null);
                RecoverPasswordActivity.this.showEmailSentDialog(email);
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof FirebaseAuthInvalidUserException || e instanceof FirebaseAuthInvalidCredentialsException) {
                    RecoverPasswordActivity.this.mEmailInputLayout.setError((CharSequence)RecoverPasswordActivity.this.getString(R.string.fui_error_email_does_not_exist));
                } else {
                    RecoverPasswordActivity.this.mEmailInputLayout.setError((CharSequence)RecoverPasswordActivity.this.getString(R.string.fui_error_unknown));
                }
            }
        });
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.top_progress_bar);
        this.mSubmitButton = (Button)this.findViewById(R.id.button_done);
        this.mEmailInputLayout = (TextInputLayout)this.findViewById(R.id.email_layout);
        this.mEmailEditText = (EditText)this.findViewById(R.id.email);
        this.mEmailFieldValidator = new EmailFieldValidator(this.mEmailInputLayout);
        String email = this.getIntent().getStringExtra("extra_email");
        if (email != null) {
            this.mEmailEditText.setText((CharSequence)email);
        }
        ImeHelper.setImeOnDoneListener(this.mEmailEditText, this);
        this.mSubmitButton.setOnClickListener((View.OnClickListener)this);
        TextView footerText = (TextView)this.findViewById(R.id.email_footer_tos_and_pp_text);
        PrivacyDisclosureUtils.setupTermsOfServiceFooter((Context)this, this.getFlowParams(), footerText);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.button_done) {
            this.onDonePressed();
        }
    }

    @Override
    public void onDonePressed() {
        if (this.mEmailFieldValidator.validate((CharSequence)this.mEmailEditText.getText())) {
            if (this.getFlowParams().passwordResetSettings != null) {
                this.resetPassword(this.mEmailEditText.getText().toString(), this.getFlowParams().passwordResetSettings);
            } else {
                this.resetPassword(this.mEmailEditText.getText().toString(), null);
            }
        }
    }

    private void resetPassword(String email, @Nullable ActionCodeSettings passwordResetSettings) {
        this.mHandler.startReset(email, passwordResetSettings);
    }

    private void showEmailSentDialog(String email) {
        new AlertDialog.Builder((Context)this).setTitle(R.string.fui_title_confirm_recover_password).setMessage((CharSequence)this.getString(R.string.fui_confirm_recovery_body, new Object[]{email})).setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                RecoverPasswordActivity.this.finish(-1, new Intent());
            }
        }).setPositiveButton(17039370, null).show();
    }

    @Override
    public void showProgress(int message) {
        this.mSubmitButton.setEnabled(false);
        this.mProgressBar.setVisibility(0);
    }

    @Override
    public void hideProgress() {
        this.mSubmitButton.setEnabled(true);
        this.mProgressBar.setVisibility(4);
    }
}

