/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ListAdapter;
import android.widget.ListView;
import androidx.annotation.NonNull;
import androidx.appcompat.widget.AppCompatEditText;
import com.firebase.ui.auth.data.model.CountryInfo;
import com.firebase.ui.auth.ui.phone.CountryListAdapter;
import com.firebase.ui.auth.util.data.PhoneNumberUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class CountryListSpinner
extends AppCompatEditText
implements View.OnClickListener {
    private static final String KEY_SUPER_STATE = "KEY_SUPER_STATE";
    private static final String KEY_COUNTRY_INFO = "KEY_COUNTRY_INFO";
    private final String mTextFormat;
    private final DialogPopup mDialogPopup;
    private final CountryListAdapter mCountryListAdapter;
    private View.OnClickListener mListener;
    private String mSelectedCountryName;
    private CountryInfo mSelectedCountryInfo;
    private Set<String> mAllowedCountryIsos = new HashSet<String>();
    private Set<String> mBlockedCountryIsos = new HashSet<String>();

    public CountryListSpinner(Context context) {
        this(context, null, 0x1010081);
    }

    public CountryListSpinner(Context context, AttributeSet attrs) {
        this(context, attrs, 0x1010081);
    }

    public CountryListSpinner(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        super.setOnClickListener((View.OnClickListener)this);
        this.mCountryListAdapter = new CountryListAdapter(this.getContext());
        this.mDialogPopup = new DialogPopup(this.mCountryListAdapter);
        this.mTextFormat = "%1$s  +%2$d";
        this.mSelectedCountryName = "";
    }

    public void init(Bundle params) {
        if (params != null) {
            List<CountryInfo> countries = this.getCountriesToDisplayInSpinner(params);
            this.setCountriesToDisplay(countries);
            this.setDefaultCountryForSpinner(countries);
        }
    }

    private List<CountryInfo> getCountriesToDisplayInSpinner(Bundle params) {
        this.initCountrySpinnerIsosFromParams(params);
        Map<String, Integer> countryInfoMap = PhoneNumberUtils.getImmutableCountryIsoMap();
        if (this.mAllowedCountryIsos.isEmpty() && this.mBlockedCountryIsos.isEmpty()) {
            this.mAllowedCountryIsos = new HashSet<String>(countryInfoMap.keySet());
        }
        ArrayList<CountryInfo> countryInfoList = new ArrayList<CountryInfo>();
        HashSet<String> excludedCountries = new HashSet<String>();
        if (!this.mBlockedCountryIsos.isEmpty()) {
            excludedCountries.addAll(this.mBlockedCountryIsos);
        } else {
            excludedCountries.addAll(countryInfoMap.keySet());
            excludedCountries.removeAll(this.mAllowedCountryIsos);
        }
        for (String countryIso : countryInfoMap.keySet()) {
            if (excludedCountries.contains(countryIso)) continue;
            countryInfoList.add(new CountryInfo(new Locale("", countryIso), countryInfoMap.get(countryIso)));
        }
        Collections.sort(countryInfoList);
        return countryInfoList;
    }

    private void initCountrySpinnerIsosFromParams(@NonNull Bundle params) {
        ArrayList allowedCountries = params.getStringArrayList("allowlisted_countries");
        ArrayList blockedCountries = params.getStringArrayList("blocklisted_countries");
        if (allowedCountries != null) {
            this.mAllowedCountryIsos = this.convertCodesToIsos(allowedCountries);
        }
        if (blockedCountries != null) {
            this.mBlockedCountryIsos = this.convertCodesToIsos(blockedCountries);
        }
    }

    private Set<String> convertCodesToIsos(@NonNull List<String> codes) {
        HashSet<String> isos = new HashSet<String>();
        for (String code : codes) {
            if (PhoneNumberUtils.isValid(code)) {
                isos.addAll(PhoneNumberUtils.getCountryIsosFromCountryCode(code));
                continue;
            }
            isos.add(code);
        }
        return isos;
    }

    public void setCountriesToDisplay(List<CountryInfo> countries) {
        this.mCountryListAdapter.setData(countries);
    }

    private void setDefaultCountryForSpinner(List<CountryInfo> countries) {
        CountryInfo countryInfo = PhoneNumberUtils.getCurrentCountryInfo(this.getContext());
        if (this.isValidIso(countryInfo.getLocale().getCountry())) {
            this.setSelectedForCountry(countryInfo.getCountryCode(), countryInfo.getLocale());
        } else if (countries.iterator().hasNext()) {
            countryInfo = countries.iterator().next();
            this.setSelectedForCountry(countryInfo.getCountryCode(), countryInfo.getLocale());
        }
    }

    public boolean isValidIso(String iso) {
        iso = iso.toUpperCase(Locale.getDefault());
        boolean valid = true;
        if (!this.mAllowedCountryIsos.isEmpty()) {
            boolean bl = valid = valid && this.mAllowedCountryIsos.contains(iso);
        }
        if (!this.mBlockedCountryIsos.isEmpty()) {
            valid = valid && !this.mBlockedCountryIsos.contains(iso);
        }
        return valid;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_SUPER_STATE, superState);
        bundle.putParcelable(KEY_COUNTRY_INFO, (Parcelable)this.mSelectedCountryInfo);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof Bundle)) {
            super.onRestoreInstanceState(state);
            return;
        }
        Bundle bundle = (Bundle)state;
        Parcelable superState = bundle.getParcelable(KEY_SUPER_STATE);
        this.mSelectedCountryInfo = (CountryInfo)bundle.getParcelable(KEY_COUNTRY_INFO);
        super.onRestoreInstanceState(superState);
    }

    private static void hideKeyboard(Context context, View view) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
    }

    public void setSelectedForCountry(int countryCode, Locale locale) {
        this.setText(String.format(this.mTextFormat, CountryInfo.localeToEmoji(locale), countryCode));
        this.mSelectedCountryInfo = new CountryInfo(locale, countryCode);
    }

    public void setSelectedForCountry(Locale locale, String countryCode) {
        String countryName;
        if (this.isValidIso(locale.getCountry()) && !TextUtils.isEmpty((CharSequence)(countryName = locale.getDisplayName())) && !TextUtils.isEmpty((CharSequence)countryCode)) {
            this.mSelectedCountryName = countryName;
            this.setSelectedForCountry(Integer.parseInt(countryCode), locale);
        }
    }

    public CountryInfo getSelectedCountryInfo() {
        return this.mSelectedCountryInfo;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mDialogPopup.isShowing()) {
            this.mDialogPopup.dismiss();
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mListener = l;
    }

    public void onClick(View view) {
        this.mDialogPopup.show(this.mCountryListAdapter.getPositionForCountry(this.mSelectedCountryName));
        CountryListSpinner.hideKeyboard(this.getContext(), (View)this);
        this.executeUserClickListener(view);
    }

    private void executeUserClickListener(View view) {
        if (this.mListener != null) {
            this.mListener.onClick(view);
        }
    }

    public class DialogPopup
    implements DialogInterface.OnClickListener {
        private static final long DELAY_MILLIS = 10L;
        private final CountryListAdapter listAdapter;
        private AlertDialog dialog;

        DialogPopup(CountryListAdapter adapter) {
            this.listAdapter = adapter;
        }

        public void dismiss() {
            if (this.dialog != null) {
                this.dialog.dismiss();
                this.dialog = null;
            }
        }

        public boolean isShowing() {
            return this.dialog != null && this.dialog.isShowing();
        }

        public void show(final int selected) {
            if (this.listAdapter == null) {
                return;
            }
            AlertDialog.Builder builder = new AlertDialog.Builder(CountryListSpinner.this.getContext());
            this.dialog = builder.setSingleChoiceItems((ListAdapter)this.listAdapter, 0, (DialogInterface.OnClickListener)this).create();
            this.dialog.setCanceledOnTouchOutside(true);
            final ListView listView = this.dialog.getListView();
            listView.setFastScrollEnabled(true);
            listView.setScrollbarFadingEnabled(false);
            listView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    listView.setSelection(selected);
                }
            }, 10L);
            this.dialog.show();
        }

        public void onClick(DialogInterface dialog, int which) {
            CountryInfo countryInfo = (CountryInfo)this.listAdapter.getItem(which);
            CountryListSpinner.this.mSelectedCountryName = countryInfo.getLocale().getDisplayCountry();
            CountryListSpinner.this.setSelectedForCountry(countryInfo.getCountryCode(), countryInfo.getLocale());
            this.dismiss();
        }
    }
}

