/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.data;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.gms.common.internal.Preconditions;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ContinueUrlBuilder {
    private StringBuilder mContinueUrl;

    public ContinueUrlBuilder(@NonNull String url) {
        Preconditions.checkNotEmpty((String)url);
        this.mContinueUrl = new StringBuilder(url + "?");
    }

    public ContinueUrlBuilder appendSessionId(@NonNull String sessionId) {
        this.addQueryParam("ui_sid", sessionId);
        return this;
    }

    public ContinueUrlBuilder appendAnonymousUserId(@NonNull String anonymousUserId) {
        this.addQueryParam("ui_auid", anonymousUserId);
        return this;
    }

    public ContinueUrlBuilder appendProviderId(@NonNull String providerId) {
        this.addQueryParam("ui_pid", providerId);
        return this;
    }

    public ContinueUrlBuilder appendForceSameDeviceBit(@NonNull boolean forceSameDevice) {
        String bit = forceSameDevice ? "1" : "0";
        this.addQueryParam("ui_sd", bit);
        return this;
    }

    private void addQueryParam(String key, String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            return;
        }
        boolean isFirstParam = this.mContinueUrl.charAt(this.mContinueUrl.length() - 1) == '?';
        String mark = isFirstParam ? "" : "&";
        this.mContinueUrl.append(String.format("%s%s=%s", mark, key, value));
    }

    public String build() {
        if (this.mContinueUrl.charAt(this.mContinueUrl.length() - 1) == '?') {
            this.mContinueUrl.setLength(this.mContinueUrl.length() - 1);
        }
        return this.mContinueUrl.toString();
    }
}

