/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.ui;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.RestrictTo;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.widget.TextViewCompat;
import com.firebase.ui.auth.R;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SupportVectorDrawablesButton
extends AppCompatButton {
    public SupportVectorDrawablesButton(Context context) {
        super(context);
    }

    public SupportVectorDrawablesButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initSupportVectorDrawablesAttrs(attrs);
    }

    public SupportVectorDrawablesButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initSupportVectorDrawablesAttrs(attrs);
    }

    private void initSupportVectorDrawablesAttrs(AttributeSet attrs) {
        if (attrs == null) {
            return;
        }
        TypedArray attributeArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SupportVectorDrawablesButton);
        Drawable drawableStart = null;
        Drawable drawableEnd = null;
        Drawable drawableTop = null;
        Drawable drawableBottom = null;
        if (Build.VERSION.SDK_INT >= 21) {
            drawableStart = attributeArray.getDrawable(R.styleable.SupportVectorDrawablesButton_drawableStartCompat);
            drawableEnd = attributeArray.getDrawable(R.styleable.SupportVectorDrawablesButton_drawableEndCompat);
            drawableTop = attributeArray.getDrawable(R.styleable.SupportVectorDrawablesButton_drawableTopCompat);
            drawableBottom = attributeArray.getDrawable(R.styleable.SupportVectorDrawablesButton_drawableBottomCompat);
        } else {
            int drawableStartId = attributeArray.getResourceId(R.styleable.SupportVectorDrawablesButton_drawableStartCompat, -1);
            int drawableEndId = attributeArray.getResourceId(R.styleable.SupportVectorDrawablesButton_drawableEndCompat, -1);
            int drawableTopId = attributeArray.getResourceId(R.styleable.SupportVectorDrawablesButton_drawableTopCompat, -1);
            int drawableBottomId = attributeArray.getResourceId(R.styleable.SupportVectorDrawablesButton_drawableBottomCompat, -1);
            if (drawableStartId != -1) {
                drawableStart = AppCompatResources.getDrawable((Context)this.getContext(), (int)drawableStartId);
            }
            if (drawableEndId != -1) {
                drawableEnd = AppCompatResources.getDrawable((Context)this.getContext(), (int)drawableEndId);
            }
            if (drawableTopId != -1) {
                drawableTop = AppCompatResources.getDrawable((Context)this.getContext(), (int)drawableTopId);
            }
            if (drawableBottomId != -1) {
                drawableBottom = AppCompatResources.getDrawable((Context)this.getContext(), (int)drawableBottomId);
            }
        }
        TextViewCompat.setCompoundDrawablesRelativeWithIntrinsicBounds((TextView)this, (Drawable)drawableStart, (Drawable)drawableTop, (Drawable)drawableEnd, (Drawable)drawableBottom);
        attributeArray.recycle();
    }
}

