/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.lifecycle.Observer;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.State;
import com.firebase.ui.auth.ui.FragmentBase;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.ProgressView;
import com.firebase.ui.auth.util.ui.FlowUtils;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ResourceObserver<T>
implements Observer<Resource<T>> {
    private final ProgressView mProgressView;
    private final HelperActivityBase mActivity;
    private final FragmentBase mFragment;
    private final int mLoadingMessage;

    protected ResourceObserver(@NonNull HelperActivityBase activity) {
        this(activity, null, activity, R.string.fui_progress_dialog_loading);
    }

    protected ResourceObserver(@NonNull HelperActivityBase activity, @StringRes int message) {
        this(activity, null, activity, message);
    }

    protected ResourceObserver(@NonNull FragmentBase fragment) {
        this(null, fragment, fragment, R.string.fui_progress_dialog_loading);
    }

    protected ResourceObserver(@NonNull FragmentBase fragment, @StringRes int message) {
        this(null, fragment, fragment, message);
    }

    private ResourceObserver(HelperActivityBase activity, FragmentBase fragment, ProgressView progressView, int message) {
        this.mActivity = activity;
        this.mFragment = fragment;
        if (this.mActivity == null && this.mFragment == null) {
            throw new IllegalStateException("ResourceObserver must be attached to an Activity or a Fragment");
        }
        this.mProgressView = progressView;
        this.mLoadingMessage = message;
    }

    public final void onChanged(Resource<T> resource) {
        if (resource.getState() == State.LOADING) {
            this.mProgressView.showProgress(this.mLoadingMessage);
            return;
        }
        this.mProgressView.hideProgress();
        if (resource.isUsed()) {
            return;
        }
        if (resource.getState() == State.SUCCESS) {
            this.onSuccess(resource.getValue());
        } else if (resource.getState() == State.FAILURE) {
            Exception e = resource.getException();
            boolean unhandled = this.mFragment == null ? FlowUtils.unhandled(this.mActivity, e) : FlowUtils.unhandled(this.mFragment, e);
            if (unhandled) {
                Log.e((String)"AuthUI", (String)"A sign-in error occurred.", (Throwable)e);
                this.onFailure(e);
            }
        }
    }

    protected abstract void onSuccess(@NonNull T var1);

    protected abstract void onFailure(@NonNull Exception var1);
}

