/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.firebase.ui.auth.FirebaseAuthAnonymousUpgradeException;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.UserCancellationException;
import com.firebase.ui.auth.data.remote.SignInKickstarter;
import com.firebase.ui.auth.ui.HelperActivityBase;
import com.firebase.ui.auth.ui.InvisibleActivityBase;
import com.firebase.ui.auth.viewmodel.ResourceObserver;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class KickoffActivity
extends InvisibleActivityBase {
    private SignInKickstarter mKickstarter;

    public static Intent createIntent(Context context, FlowParameters flowParams) {
        return KickoffActivity.createBaseIntent(context, KickoffActivity.class, flowParams);
    }

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mKickstarter = (SignInKickstarter)new ViewModelProvider((ViewModelStoreOwner)this).get(SignInKickstarter.class);
        this.mKickstarter.init(this.getFlowParams());
        this.mKickstarter.getOperation().observe((LifecycleOwner)this, (Observer)new ResourceObserver<IdpResponse>((HelperActivityBase)this){

            @Override
            protected void onSuccess(@NonNull IdpResponse response) {
                KickoffActivity.this.finish(-1, response.toIntent());
            }

            @Override
            protected void onFailure(@NonNull Exception e) {
                if (e instanceof UserCancellationException) {
                    KickoffActivity.this.finish(0, null);
                } else if (e instanceof FirebaseAuthAnonymousUpgradeException) {
                    IdpResponse res = ((FirebaseAuthAnonymousUpgradeException)e).getResponse();
                    KickoffActivity.this.finish(0, new Intent().putExtra("extra_idp_response", (Parcelable)res));
                } else {
                    KickoffActivity.this.finish(0, IdpResponse.getErrorIntent(e));
                }
            }
        });
        Task checkPlayServicesTask = this.getFlowParams().isPlayServicesRequired() ? GoogleApiAvailability.getInstance().makeGooglePlayServicesAvailable((Activity)this) : Tasks.forResult((Object)null);
        checkPlayServicesTask.addOnSuccessListener((Activity)this, aVoid -> {
            if (savedInstanceState != null) {
                return;
            }
            this.mKickstarter.start();
        }).addOnFailureListener((Activity)this, e -> this.finish(0, IdpResponse.getErrorIntent(new FirebaseUiException(2, (Throwable)e))));
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 106 && (resultCode == 113 || resultCode == 114)) {
            this.invalidateEmailLink();
        }
        this.mKickstarter.onActivityResult(requestCode, resultCode, data);
    }

    public void invalidateEmailLink() {
        FlowParameters flowParameters = this.getFlowParams();
        flowParameters.emailLink = null;
        this.setIntent(this.getIntent().putExtra("extra_flow_params", (Parcelable)flowParameters));
    }
}

