/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.data.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.data.model.State;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class Resource<T> {
    private final State mState;
    private final T mValue;
    private final Exception mException;
    private boolean mIsUsed;

    private Resource(State state, T value, Exception exception) {
        this.mState = state;
        this.mValue = value;
        this.mException = exception;
    }

    @NonNull
    public static <T> Resource<T> forSuccess(@NonNull T value) {
        return new Resource<T>(State.SUCCESS, value, null);
    }

    @NonNull
    public static <T> Resource<T> forFailure(@NonNull Exception e) {
        return new Resource<Object>(State.FAILURE, null, e);
    }

    @NonNull
    public static <T> Resource<T> forLoading() {
        return new Resource<Object>(State.LOADING, null, null);
    }

    @NonNull
    public State getState() {
        return this.mState;
    }

    @Nullable
    public final Exception getException() {
        this.mIsUsed = true;
        return this.mException;
    }

    @Nullable
    public T getValue() {
        this.mIsUsed = true;
        return this.mValue;
    }

    public boolean isUsed() {
        return this.mIsUsed;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.mState == resource.mState && (this.mValue == null ? resource.mValue == null : this.mValue.equals(resource.mValue)) && (this.mException == null ? resource.mException == null : this.mException.equals(resource.mException));
    }

    public int hashCode() {
        int result = this.mState.hashCode();
        result = 31 * result + (this.mValue == null ? 0 : this.mValue.hashCode());
        result = 31 * result + (this.mException == null ? 0 : this.mException.hashCode());
        return result;
    }

    public String toString() {
        return "Resource{mState=" + (Object)((Object)this.mState) + ", mValue=" + this.mValue + ", mException=" + this.mException + '}';
    }
}

