/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.ui.phone;

import android.app.Activity;
import android.app.Application;
import android.content.ActivityNotFoundException;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.firebase.ui.auth.data.model.PhoneNumberVerificationRequiredException;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.ui.phone.PhoneVerification;
import com.firebase.ui.auth.viewmodel.AuthViewModelBase;
import com.google.firebase.FirebaseException;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.PhoneAuthCredential;
import com.google.firebase.auth.PhoneAuthOptions;
import com.google.firebase.auth.PhoneAuthProvider;
import java.util.concurrent.TimeUnit;

public class PhoneNumberVerificationHandler
extends AuthViewModelBase<PhoneVerification> {
    private static final long AUTO_RETRIEVAL_TIMEOUT_SECONDS = 120L;
    private static final String VERIFICATION_ID_KEY = "verification_id";
    private String mVerificationId;
    private PhoneAuthProvider.ForceResendingToken mForceResendingToken;

    public PhoneNumberVerificationHandler(Application application) {
        super(application);
    }

    public void verifyPhoneNumber(@NonNull Activity activity, final String number, boolean force) {
        this.setResult(Resource.forLoading());
        PhoneAuthOptions.Builder optionsBuilder = PhoneAuthOptions.newBuilder((FirebaseAuth)this.getAuth()).setPhoneNumber(number).setTimeout(Long.valueOf(120L), TimeUnit.SECONDS).setActivity(activity).setCallbacks(new PhoneAuthProvider.OnVerificationStateChangedCallbacks(){

            public void onVerificationCompleted(@NonNull PhoneAuthCredential credential) {
                PhoneNumberVerificationHandler.this.setResult(Resource.forSuccess(new PhoneVerification(number, credential, true)));
            }

            public void onVerificationFailed(@NonNull FirebaseException e) {
                PhoneNumberVerificationHandler.this.setResult(Resource.forFailure((Exception)e));
            }

            public void onCodeSent(@NonNull String verificationId, @NonNull PhoneAuthProvider.ForceResendingToken token) {
                PhoneNumberVerificationHandler.this.mVerificationId = verificationId;
                PhoneNumberVerificationHandler.this.mForceResendingToken = token;
                PhoneNumberVerificationHandler.this.setResult(Resource.forFailure(new PhoneNumberVerificationRequiredException(number)));
            }
        });
        if (force) {
            optionsBuilder.setForceResendingToken(this.mForceResendingToken);
        }
        if (this.isBrowserAvailable(activity)) {
            PhoneAuthProvider.verifyPhoneNumber((PhoneAuthOptions)optionsBuilder.build());
        } else {
            this.setResult(Resource.forFailure((Exception)new ActivityNotFoundException("No browser was found in this device")));
        }
    }

    public void submitVerificationCode(String number, String code) {
        this.setResult(Resource.forSuccess(new PhoneVerification(number, PhoneAuthProvider.getCredential((String)this.mVerificationId, (String)code), false)));
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        outState.putString(VERIFICATION_ID_KEY, this.mVerificationId);
    }

    public void onRestoreInstanceState(@Nullable Bundle savedInstanceState) {
        if (this.mVerificationId == null && savedInstanceState != null) {
            this.mVerificationId = savedInstanceState.getString(VERIFICATION_ID_KEY);
        }
    }

    private boolean isBrowserAvailable(Activity activity) {
        Intent browserIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://"));
        return browserIntent.resolveActivity(activity.getPackageManager()) != null;
    }
}

