/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;

public final class Preconditions {
    private Preconditions() {
    }

    @NonNull
    public static <T> T checkNotNull(@Nullable T val, @NonNull String errorMessageTemplate, Object ... errorMessageArgs) {
        if (val == null) {
            if (errorMessageArgs == null) {
                throw new NullPointerException(errorMessageTemplate);
            }
            throw new NullPointerException(String.format(errorMessageTemplate, errorMessageArgs));
        }
        return val;
    }

    @StyleRes
    public static int checkValidStyle(@NonNull Context context, int styleId, @NonNull String errorMessageTemplate, Object ... errorMessageArguments) {
        try {
            String resourceType = context.getResources().getResourceTypeName(styleId);
            if (!"style".equals(resourceType)) {
                throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArguments));
            }
            return styleId;
        }
        catch (Resources.NotFoundException ex) {
            throw new IllegalArgumentException(String.format(errorMessageTemplate, errorMessageArguments));
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void checkUnset(@NonNull Bundle b, @Nullable String message, String ... keys) {
        for (String key : keys) {
            if (!b.containsKey(key)) continue;
            throw new IllegalStateException(message);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void checkConfigured(@NonNull Context context, @Nullable String message, int ... ids) {
        for (int id2 : ids) {
            if (!context.getString(id2).equals("CHANGE-ME")) continue;
            throw new IllegalStateException(message);
        }
    }

    public static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

