/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.ui;

import android.content.Context;
import android.net.Uri;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.browser.customtabs.CustomTabColorSchemeParams;
import androidx.browser.customtabs.CustomTabsIntent;
import androidx.core.content.ContextCompat;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.google.android.material.color.MaterialColors;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PreambleHandler {
    private static final String BTN_TARGET = "%BTN%";
    private static final String TOS_TARGET = "%TOS%";
    private static final String PP_TARGET = "%PP%";
    private static final int NO_BUTTON = -1;
    private final Context mContext;
    private final FlowParameters mFlowParameters;
    private final int mButtonText;
    private SpannableStringBuilder mBuilder;

    private PreambleHandler(Context context, FlowParameters parameters, @StringRes int buttonText) {
        this.mContext = context;
        this.mFlowParameters = parameters;
        this.mButtonText = buttonText;
    }

    public static void setup(Context context, FlowParameters parameters, @StringRes int textViewText, TextView textView) {
        PreambleHandler.setup(context, parameters, -1, textViewText, textView);
    }

    public static void setup(Context context, FlowParameters parameters, @StringRes int buttonText, @StringRes int textViewText, TextView textView) {
        PreambleHandler handler = new PreambleHandler(context, parameters, buttonText);
        handler.initPreamble(textViewText);
        handler.setPreamble(textView);
    }

    private void setPreamble(TextView textView) {
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        textView.setText((CharSequence)this.mBuilder);
    }

    private void initPreamble(@StringRes int textViewText) {
        String withTargets = this.getPreambleStringWithTargets(textViewText, this.mButtonText != -1);
        if (withTargets == null) {
            return;
        }
        this.mBuilder = new SpannableStringBuilder((CharSequence)withTargets);
        this.replaceTarget(BTN_TARGET, this.mButtonText);
        this.replaceUrlTarget(TOS_TARGET, R.string.fui_terms_of_service, this.mFlowParameters.termsOfServiceUrl);
        this.replaceUrlTarget(PP_TARGET, R.string.fui_privacy_policy, this.mFlowParameters.privacyPolicyUrl);
    }

    private void replaceTarget(String target, @StringRes int replacementRes) {
        int targetIndex = this.mBuilder.toString().indexOf(target);
        if (targetIndex != -1) {
            String replacement = this.mContext.getString(replacementRes);
            this.mBuilder.replace(targetIndex, targetIndex + target.length(), (CharSequence)replacement);
        }
    }

    private void replaceUrlTarget(String target, @StringRes int replacementRes, String url) {
        int targetIndex = this.mBuilder.toString().indexOf(target);
        if (targetIndex != -1) {
            String replacement = this.mContext.getString(replacementRes);
            this.mBuilder.replace(targetIndex, targetIndex + target.length(), (CharSequence)replacement);
            int end = targetIndex + replacement.length();
            this.mBuilder.setSpan((Object)new CustomTabsSpan(this.mContext, url), targetIndex, end, 0);
        }
    }

    @Nullable
    private String getPreambleStringWithTargets(@StringRes int textViewText, boolean hasButton) {
        boolean privacyPolicyUrlProvided;
        boolean termsOfServiceUrlProvided = !TextUtils.isEmpty((CharSequence)this.mFlowParameters.termsOfServiceUrl);
        boolean bl = privacyPolicyUrlProvided = !TextUtils.isEmpty((CharSequence)this.mFlowParameters.privacyPolicyUrl);
        if (termsOfServiceUrlProvided && privacyPolicyUrlProvided) {
            Object[] objectArray;
            if (hasButton) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = BTN_TARGET;
                objectArray2[1] = TOS_TARGET;
                objectArray = objectArray2;
                objectArray2[2] = PP_TARGET;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = TOS_TARGET;
                objectArray = objectArray3;
                objectArray3[1] = PP_TARGET;
            }
            Object[] targets = objectArray;
            return this.mContext.getString(textViewText, targets);
        }
        return null;
    }

    private static final class CustomTabsSpan
    extends URLSpan {
        private final WeakReference<Context> mContext;
        private final String mUrl;
        private final CustomTabsIntent mCustomTabsIntent;

        public CustomTabsSpan(Context context, String url) {
            super(url);
            this.mContext = new WeakReference<Context>(context);
            this.mUrl = url;
            int defaultToolbarColor = ContextCompat.getColor((Context)context, (int)R.color.design_default_color_primary);
            int toolbarColor = MaterialColors.getColor((Context)context, (int)R.attr.colorSurface, (int)defaultToolbarColor);
            this.mCustomTabsIntent = new CustomTabsIntent.Builder().setDefaultColorSchemeParams(new CustomTabColorSchemeParams.Builder().setToolbarColor(toolbarColor).build()).setShowTitle(true).build();
        }

        public void onClick(View widget) {
            Context context = (Context)this.mContext.get();
            if (context != null) {
                this.mCustomTabsIntent.launchUrl(context, Uri.parse((String)this.mUrl));
            }
        }
    }
}

