/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.viewmodel.email;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.firebase.ui.auth.data.model.Resource;
import com.firebase.ui.auth.data.model.User;
import com.firebase.ui.auth.data.remote.ProfileMerger;
import com.firebase.ui.auth.util.data.AuthOperationManager;
import com.firebase.ui.auth.util.data.TaskFailureLogger;
import com.firebase.ui.auth.viewmodel.SignInViewModelBase;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.AuthResult;
import com.google.firebase.auth.EmailAuthProvider;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class WelcomeBackPasswordHandler
extends SignInViewModelBase {
    private static final String TAG = "WBPasswordHandler";
    private String mPendingPassword;

    public WelcomeBackPasswordHandler(Application application) {
        super(application);
    }

    public void startSignIn(@NonNull String email, @NonNull String password, @NonNull IdpResponse inputResponse, @Nullable AuthCredential credential) {
        this.setResult(Resource.forLoading());
        this.mPendingPassword = password;
        IdpResponse outputResponse = credential == null ? new IdpResponse.Builder(new User.Builder("password", email).build()).build() : new IdpResponse.Builder(inputResponse.getUser()).setPendingCredential(inputResponse.getCredentialForLinking()).setToken(inputResponse.getIdpToken()).setSecret(inputResponse.getIdpSecret()).build();
        AuthOperationManager authOperationManager = AuthOperationManager.getInstance();
        if (authOperationManager.canUpgradeAnonymous(this.getAuth(), (FlowParameters)this.getArguments())) {
            AuthCredential credToValidate = EmailAuthProvider.getCredential((String)email, (String)password);
            if (AuthUI.SOCIAL_PROVIDERS.contains(inputResponse.getProviderType())) {
                authOperationManager.safeLink(credToValidate, credential, (FlowParameters)this.getArguments()).addOnSuccessListener(result -> this.handleMergeFailure(credToValidate)).addOnFailureListener(e -> this.setResult(Resource.forFailure(e)));
            } else {
                authOperationManager.validateCredential(credToValidate, (FlowParameters)this.getArguments()).addOnCompleteListener(task -> {
                    if (task.isSuccessful()) {
                        this.handleMergeFailure(credToValidate);
                    } else {
                        this.setResult(Resource.forFailure(task.getException()));
                    }
                });
            }
        } else {
            this.getAuth().signInWithEmailAndPassword(email, password).continueWithTask(task -> {
                AuthResult result = (AuthResult)task.getResult(Exception.class);
                if (credential == null) {
                    return Tasks.forResult((Object)result);
                }
                return result.getUser().linkWithCredential(credential).continueWithTask((Continuation)new ProfileMerger(outputResponse)).addOnFailureListener((OnFailureListener)new TaskFailureLogger(TAG, "linkWithCredential+merge failed."));
            }).addOnSuccessListener(result -> this.handleSuccess(outputResponse, (AuthResult)result)).addOnFailureListener(e -> this.setResult(Resource.forFailure(e))).addOnFailureListener((OnFailureListener)new TaskFailureLogger(TAG, "signInWithEmailAndPassword failed."));
        }
    }

    public String getPendingPassword() {
        return this.mPendingPassword;
    }
}

