/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.storage.images;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.Key;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.data.DataFetcher;
import com.bumptech.glide.load.model.ModelLoader;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.bumptech.glide.load.model.MultiModelLoaderFactory;
import com.google.firebase.storage.StorageReference;
import com.google.firebase.storage.StreamDownloadTask;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;

public class FirebaseImageLoader
implements ModelLoader<StorageReference, InputStream> {
    private static final String TAG = "FirebaseImageLoader";

    @Nullable
    public ModelLoader.LoadData<InputStream> buildLoadData(@NonNull StorageReference reference, int height, int width, @NonNull Options options) {
        return new ModelLoader.LoadData((Key)new FirebaseStorageKey(reference), (DataFetcher)new FirebaseStorageFetcher(reference));
    }

    public boolean handles(@NonNull StorageReference reference) {
        return true;
    }

    private static class FirebaseStorageKey
    implements Key {
        private StorageReference mRef;

        public FirebaseStorageKey(StorageReference ref) {
            this.mRef = ref;
        }

        public void updateDiskCacheKey(@NonNull MessageDigest digest) {
            digest.update(this.mRef.getPath().getBytes(Charset.defaultCharset()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FirebaseStorageKey key = (FirebaseStorageKey)o;
            return this.mRef.equals((Object)key.mRef);
        }

        public int hashCode() {
            return this.mRef.hashCode();
        }
    }

    private static class FirebaseStorageFetcher
    implements DataFetcher<InputStream> {
        private StorageReference mRef;
        private StreamDownloadTask mStreamTask;
        private InputStream mInputStream;

        public FirebaseStorageFetcher(StorageReference ref) {
            this.mRef = ref;
        }

        public void loadData(@NonNull Priority priority, @NonNull DataFetcher.DataCallback<? super InputStream> callback) {
            this.mStreamTask = this.mRef.getStream();
            this.mStreamTask.addOnSuccessListener(snapshot -> {
                this.mInputStream = snapshot.getStream();
                callback.onDataReady((Object)this.mInputStream);
            }).addOnFailureListener(e -> callback.onLoadFailed(e));
        }

        public void cleanup() {
            if (this.mInputStream != null) {
                try {
                    this.mInputStream.close();
                    this.mInputStream = null;
                }
                catch (IOException e) {
                    Log.w((String)FirebaseImageLoader.TAG, (String)"Could not close stream", (Throwable)e);
                }
            }
        }

        public void cancel() {
            if (this.mStreamTask != null && this.mStreamTask.isInProgress()) {
                this.mStreamTask.cancel();
            }
        }

        @NonNull
        public Class<InputStream> getDataClass() {
            return InputStream.class;
        }

        @NonNull
        public DataSource getDataSource() {
            return DataSource.REMOTE;
        }
    }

    public static class Factory
    implements ModelLoaderFactory<StorageReference, InputStream> {
        @NonNull
        public ModelLoader<StorageReference, InputStream> build(@NonNull MultiModelLoaderFactory factory) {
            return new FirebaseImageLoader();
        }

        public void teardown() {
        }
    }
}

