/*
 * Decompiled with CFR 0.152.
 */
package com.fiskaly.sdk;

import com.fiskaly.sdk.FiskalyClientException;
import com.fiskaly.sdk.FiskalyHttpException;
import com.fiskaly.sdk.FiskalyHttpResponse;
import com.fiskaly.sdk.FiskalyHttpTimeoutException;
import com.fiskaly.sdk.client.ClientLibrary;
import com.fiskaly.sdk.factories.ExceptionFactory;
import com.fiskaly.sdk.jsonrpc.JsonRpcRequest;
import com.fiskaly.sdk.jsonrpc.JsonRpcResponse;
import com.fiskaly.sdk.params.ParamConfig;
import com.fiskaly.sdk.params.ParamCreateContext;
import com.fiskaly.sdk.params.ParamRequest;
import com.fiskaly.sdk.params.ParamSelfTest;
import com.fiskaly.sdk.results.ResultConfig;
import com.fiskaly.sdk.results.ResultCreateContext;
import com.fiskaly.sdk.results.ResultRequest;
import com.fiskaly.sdk.results.ResultSelfTest;
import com.fiskaly.sdk.results.ResultVersion;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

public class FiskalyHttpClient {
    private transient String context;

    public FiskalyHttpClient(String apiKey, String apiSecret, URI baseUrl, String email, String password, String organizationId, String environment) throws IOException, FiskalyHttpTimeoutException, FiskalyClientException, FiskalyHttpException {
        ParamCreateContext params = new ParamCreateContext(apiKey, apiSecret, baseUrl, email, password, organizationId, environment);
        JsonRpcRequest request = new JsonRpcRequest("create-context", params);
        JsonRpcResponse response = FiskalyHttpClient.doInvoke(request, ResultCreateContext.class);
        this.context = ((ResultCreateContext)response.result).context;
    }

    public FiskalyHttpClient(String apiKey, String apiSecret, URI baseUrl, String email, String password) throws IOException, FiskalyHttpTimeoutException, FiskalyClientException, FiskalyHttpException {
        this(apiKey, apiSecret, baseUrl, email, password, "", "");
    }

    public FiskalyHttpClient(String apiKey, String apiSecret, URI baseUrl) throws IOException, FiskalyHttpTimeoutException, FiskalyClientException, FiskalyHttpException {
        this(apiKey, apiSecret, baseUrl, "", "", "", "");
    }

    public FiskalyHttpClient(String apiKey, String apiSecret, String baseUrl) throws IOException, URISyntaxException, FiskalyHttpException, FiskalyClientException, FiskalyHttpTimeoutException {
        this(apiKey, apiSecret, new URI(baseUrl));
    }

    public ResultVersion version() throws FiskalyHttpException, FiskalyHttpTimeoutException, FiskalyClientException, IOException {
        JsonRpcRequest request = new JsonRpcRequest("version", null);
        JsonRpcResponse response = FiskalyHttpClient.doInvoke(request, ResultVersion.class);
        return (ResultVersion)response.result;
    }

    public ResultSelfTest selfTest() throws FiskalyHttpException, FiskalyHttpTimeoutException, FiskalyClientException, IOException {
        ParamSelfTest params = new ParamSelfTest(this.context);
        JsonRpcRequest request = new JsonRpcRequest("self-test", params);
        JsonRpcResponse response = FiskalyHttpClient.doInvoke(request, ResultSelfTest.class);
        return (ResultSelfTest)response.result;
    }

    public Object echo(Object object) throws FiskalyHttpException, FiskalyHttpTimeoutException, FiskalyClientException, IOException {
        JsonRpcRequest request = new JsonRpcRequest("echo", object);
        JsonRpcResponse response = FiskalyHttpClient.doInvoke(request, Object.class);
        return response.result;
    }

    public ParamConfig.Config config(int debugLevel, String debugFile, int clientTimeout, int smaersTimeout, String httpProxy) throws FiskalyHttpException, FiskalyHttpTimeoutException, FiskalyClientException, IOException {
        ParamConfig params = new ParamConfig(this.context, new ParamConfig.Config(debugLevel, debugFile, clientTimeout, smaersTimeout, httpProxy));
        JsonRpcRequest request = new JsonRpcRequest("config", params);
        JsonRpcResponse response = FiskalyHttpClient.doInvoke(request, ResultConfig.class);
        this.context = ((ResultConfig)response.result).context;
        return ((ResultConfig)response.result).config;
    }

    public FiskalyHttpResponse request(String method, String path, byte[] body, Map<String, ?> query, Map<String, String> headers, String destinationFile) throws IOException, FiskalyHttpTimeoutException, FiskalyClientException, FiskalyHttpException {
        ParamRequest params = new ParamRequest(this.context, new ParamRequest.Request(method, path, body, query, headers, destinationFile));
        JsonRpcRequest request = new JsonRpcRequest("request", params);
        JsonRpcResponse response = FiskalyHttpClient.doInvoke(request, ResultRequest.class);
        this.context = ((ResultRequest)response.result).context;
        return new FiskalyHttpResponse(((ResultRequest)response.result).response);
    }

    public FiskalyHttpResponse request(String method, String path, byte[] body, Map<String, ?> query, Map<String, String> headers) throws IOException, FiskalyHttpTimeoutException, FiskalyClientException, FiskalyHttpException {
        return this.request(method, path, body, query, headers, null);
    }

    public FiskalyHttpResponse request(String method, String path, byte[] body, Map<String, ?> query, String destinationFile) throws IOException, FiskalyHttpException, FiskalyClientException, FiskalyHttpTimeoutException {
        return this.request(method, path, body, query, null, destinationFile);
    }

    public FiskalyHttpResponse request(String method, String path, byte[] body, Map<String, ?> query) throws IOException, FiskalyHttpException, FiskalyClientException, FiskalyHttpTimeoutException {
        return this.request(method, path, body, query, null, null);
    }

    public FiskalyHttpResponse request(String method, String path, byte[] body, String destinationFile) throws IOException, FiskalyHttpException, FiskalyClientException, FiskalyHttpTimeoutException {
        return this.request(method, path, body, null, null, destinationFile);
    }

    public FiskalyHttpResponse request(String method, String path, byte[] body) throws IOException, FiskalyHttpException, FiskalyClientException, FiskalyHttpTimeoutException {
        return this.request(method, path, body, null, null, null);
    }

    public FiskalyHttpResponse request(String method, String path, String destinationFile) throws IOException, FiskalyHttpException, FiskalyClientException, FiskalyHttpTimeoutException {
        return this.request(method, path, null, null, null, destinationFile);
    }

    public FiskalyHttpResponse request(String method, String path) throws IOException, FiskalyHttpException, FiskalyClientException, FiskalyHttpTimeoutException {
        return this.request(method, path, null, null, null, null);
    }

    private static <T> JsonRpcResponse<T> doInvoke(JsonRpcRequest request, Class<?> resultClass) throws IOException, FiskalyHttpException, FiskalyHttpTimeoutException, FiskalyClientException {
        JsonRpcResponse response = ClientLibrary.invoke(request, resultClass);
        if (response.error != null) {
            if (response.error.code == -20000) {
                throw ExceptionFactory.buildHttpException(response);
            }
            if (response.error.code == -21000) {
                throw new FiskalyHttpTimeoutException(response.error.message);
            }
            throw ExceptionFactory.buildClientException(response);
        }
        return response;
    }
}

