/*
 * Decompiled with CFR 0.152.
 */
package com.fiskaly.sdk.client;

import com.fiskaly.sdk.factories.GsonFactory;
import com.fiskaly.sdk.jsonrpc.JsonRpcRequest;
import com.fiskaly.sdk.jsonrpc.JsonRpcResponse;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.lang.reflect.Type;

public abstract class ClientLibrary {
    private static final String LIB_PREFIX = "com.fiskaly.client";
    private static final String UTF_8 = "UTF8";
    private static final String PROP_LIB_PATH = "jna.library.path";
    private static final Gson GSON = GsonFactory.createGson();

    private ClientLibrary() {
    }

    public static <T> JsonRpcResponse<T> invoke(JsonRpcRequest request, Class<?> resultClass) {
        String requestString = GSON.toJson((Object)request);
        String invocationResponse = ClientLibrary.invoke(requestString);
        Type responseType = TypeToken.getParameterized(JsonRpcResponse.class, (Type[])new Type[]{resultClass}).getType();
        return (JsonRpcResponse)GSON.fromJson(invocationResponse, responseType);
    }

    public static String invoke(String req) {
        Pointer resPtr = ClientLibrary._fiskaly_client_invoke(req);
        String resStr = resPtr.getString(0L, UTF_8);
        ClientLibrary._fiskaly_client_free(resPtr);
        return resStr;
    }

    private static String getLibName() {
        String extension;
        String os;
        if (Platform.isAndroid()) {
            return "com.fiskaly.client-v1.2.100";
        }
        if (Platform.isLinux()) {
            os = "linux";
            extension = ".so";
        } else if (Platform.isWindows()) {
            os = "windows";
            extension = ".dll";
        } else if (Platform.isMac()) {
            os = "darwin";
            extension = "";
        } else {
            throw new IllegalStateException("OS type not supported: " + Platform.getOSType());
        }
        String arch = Platform.ARCH;
        if (arch.equals("x86")) {
            arch = "386";
        } else if (arch.equals("x86-64")) {
            arch = "amd64";
        }
        return "com.fiskaly.client-" + os + "-" + arch + "-" + "v1.2.100" + extension;
    }

    private static void setLibSearchPath() {
        if (Platform.isAndroid()) {
            return;
        }
        if (System.getProperty(PROP_LIB_PATH) == null) {
            System.setProperty(PROP_LIB_PATH, ".");
        }
    }

    private static native Pointer _fiskaly_client_invoke(String var0);

    private static native void _fiskaly_client_free(Pointer var0);

    static {
        String libName = ClientLibrary.getLibName();
        ClientLibrary.setLibSearchPath();
        Native.register(ClientLibrary.class, (String)libName);
    }
}

