/*
 * Decompiled with CFR 0.152.
 */
package com.fiskaly.sdk.factories;

import com.fiskaly.sdk.FiskalyClientException;
import com.fiskaly.sdk.FiskalyHttpException;
import com.fiskaly.sdk.factories.GsonFactory;
import com.fiskaly.sdk.jsonrpc.JsonRpcResponse;
import com.fiskaly.sdk.results.ErrorData;
import com.fiskaly.sdk.results.FiskalyApiError;
import com.google.gson.Gson;
import java.io.IOException;
import net.iharder.Base64;

public abstract class ExceptionFactory {
    private static final Gson GSON = GsonFactory.createGson();

    private ExceptionFactory() {
    }

    public static <T> FiskalyHttpException buildHttpException(JsonRpcResponse<T> response) throws IOException {
        ErrorData errorData = (ErrorData)GSON.fromJson(GSON.toJson(response.error.data), ErrorData.class);
        String requestId = (String)errorData.response.headers.get("x-request-id").get(0);
        String decodedBody = new String(Base64.decode((String)errorData.response.body), "UTF-8");
        FiskalyApiError errorBody = (FiskalyApiError)GSON.fromJson(decodedBody, FiskalyApiError.class);
        return new FiskalyHttpException(errorBody.statusCode, errorBody.error, errorBody.message, errorBody.code, requestId);
    }

    public static <T> FiskalyClientException buildClientException(JsonRpcResponse<T> response) {
        return new FiskalyClientException(response.error.code, response.error.message, GSON.toJson(response.error.data));
    }
}

