/*
 * Decompiled with CFR 0.152.
 */
package com.fiskaly.sdk.jsonrpc;

import java.util.UUID;

public class JsonRpcRequest {
    public final String jsonrpc;
    public final String id;
    public final String method;
    public final Object params;

    public JsonRpcRequest(String method, Object params) {
        if (method == null || method.isEmpty()) {
            throw new IllegalArgumentException("Missing or empty \"method\" parameter");
        }
        this.method = method;
        this.params = params;
        this.jsonrpc = "2.0";
        this.id = UUID.randomUUID().toString();
    }

    public JsonRpcRequest(String method) {
        this(method, null);
    }

    public String toString() {
        return "JsonRpcRequest{jsonrpc='" + this.jsonrpc + '\'' + ", id='" + this.id + '\'' + ", method='" + this.method + '\'' + ", params=" + this.params + '}';
    }
}

