/*
 * Decompiled with CFR 0.152.
 */
package com.fit2cloud.autoconfigure;

import com.fit2cloud.autoconfigure.QuartzProperties;
import com.fit2cloud.quartz.QuartzInstanceIdGenerator;
import com.fit2cloud.quartz.SchedulerStarter;
import com.fit2cloud.quartz.anno.QuartzDataSource;
import com.fit2cloud.quartz.anno.QuartzTransactionManager;
import com.fit2cloud.quartz.service.QuartzManageService;
import com.fit2cloud.quartz.util.QuartzBeanFactory;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.CollectionUtils;

@Configuration
@EnableConfigurationProperties(value={QuartzProperties.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class QuartzAutoConfiguration {
    private DataSource dataSource;
    private PlatformTransactionManager txManager;
    private QuartzProperties properties;

    public QuartzAutoConfiguration(DataSource dataSource, @QuartzDataSource ObjectProvider<DataSource> quartzDataSource, ObjectProvider<PlatformTransactionManager> transactionManager, @QuartzTransactionManager ObjectProvider<PlatformTransactionManager> quartzTransactionManager, QuartzProperties properties) {
        this.dataSource = this.getDataSource(dataSource, quartzDataSource);
        this.txManager = this.getTransactionManager(transactionManager, quartzTransactionManager);
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="quartz", value={"enabled"}, havingValue="true")
    public SchedulerStarter schedulerStarter() {
        return new SchedulerStarter();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="quartz", value={"enabled"}, havingValue="true")
    public QuartzBeanFactory quartzBeanFactory() {
        return new QuartzBeanFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="quartz", value={"enabled"}, havingValue="true")
    public QuartzManageService quartzManageService() {
        return new QuartzManageService();
    }

    @Bean
    @ConditionalOnProperty(prefix="quartz", value={"enabled"}, havingValue="true")
    public TimeZone quartzTimeZone() {
        return TimeZone.getTimeZone(this.properties.getTimeZone());
    }

    private DataSource getDataSource(DataSource dataSource, ObjectProvider<DataSource> quartzDataSource) {
        DataSource dataSourceIfAvailable = (DataSource)quartzDataSource.getIfAvailable();
        return dataSourceIfAvailable != null ? dataSourceIfAvailable : dataSource;
    }

    private PlatformTransactionManager getTransactionManager(ObjectProvider<PlatformTransactionManager> transactionManager, ObjectProvider<PlatformTransactionManager> quartzTransactionManager) {
        PlatformTransactionManager transactionManagerIfAvailable = (PlatformTransactionManager)quartzTransactionManager.getIfAvailable();
        return transactionManagerIfAvailable != null ? transactionManagerIfAvailable : (PlatformTransactionManager)transactionManager.getIfUnique();
    }

    @Bean
    @ConditionalOnClass(value={DataSource.class})
    @ConditionalOnProperty(prefix="quartz", value={"enabled"}, havingValue="true")
    public SchedulerFactoryBean clusterSchedulerFactoryBean(ApplicationContext applicationContext) {
        SchedulerFactoryBean schedulerFactoryBean = new SchedulerFactoryBean();
        schedulerFactoryBean.setDataSource(this.dataSource);
        schedulerFactoryBean.setApplicationContext(applicationContext);
        schedulerFactoryBean.setOverwriteExistingJobs(true);
        schedulerFactoryBean.setStartupDelay((int)this.properties.getStartupDelay().getSeconds());
        Properties props = new Properties();
        props.put("org.quartz.scheduler.instanceName", this.properties.getSchedulerName());
        props.put("org.quartz.scheduler.instanceId", "AUTO");
        props.put("org.quartz.scheduler.instanceIdGenerator.class", QuartzInstanceIdGenerator.class.getName());
        props.put("org.quartz.jobStore.driverDelegateClass", "org.quartz.impl.jdbcjobstore.StdJDBCDelegate");
        props.put("org.quartz.jobStore.tablePrefix", "QRTZ_");
        props.put("org.quartz.jobStore.isClustered", "true");
        props.put("org.quartz.jobStore.clusterCheckinInterval", "20000");
        props.put("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
        String threadCount = this.properties.getThreadCount().toString();
        props.put("org.quartz.threadPool.threadCount", threadCount);
        props.put("org.quartz.threadPool.threadPriority", "5");
        props.put("org.quartz.threadPool.threadsInheritContextClassLoaderOfInitializingThread", "true");
        Map<String, String> properties = this.properties.getProperties();
        if (!CollectionUtils.isEmpty(properties)) {
            props.putAll(properties);
        }
        schedulerFactoryBean.setQuartzProperties(props);
        if (this.properties.getSchedulerName() != null) {
            schedulerFactoryBean.setBeanName(this.properties.getSchedulerName());
        }
        if (this.txManager != null) {
            schedulerFactoryBean.setTransactionManager(this.txManager);
        }
        return schedulerFactoryBean;
    }
}

