/*
 * Decompiled with CFR 0.152.
 */
package com.fit2cloud.quartz;

import com.fit2cloud.autoconfigure.QuartzProperties;
import com.fit2cloud.quartz.anno.QuartzScheduled;
import com.fit2cloud.quartz.config.ClusterQuartzFixedDelayJobBean;
import com.fit2cloud.quartz.config.ClusterQuartzJobBean;
import com.fit2cloud.quartz.config.FixedDelayJobData;
import com.fit2cloud.quartz.service.QuartzManageService;
import com.fit2cloud.quartz.util.JobDetailTrigger;
import java.lang.reflect.Method;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.SchedulingException;
import org.springframework.util.ReflectionUtils;

public class SchedulerStarter
implements BeanPostProcessor,
ApplicationContextAware,
ApplicationRunner {
    private Logger logger = LoggerFactory.getLogger(SchedulerStarter.class);
    private Instant now;
    @Autowired
    private Scheduler scheduler;
    @Autowired
    private TimeZone quartzTimeZone;
    @Autowired
    private QuartzProperties quartzProperties;
    private Map<String, JobDetailTrigger> jobDetailTriggerMap = new HashMap<String, JobDetailTrigger>();
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private QuartzManageService quartzManageService;

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] methods;
        for (Method method : methods = ReflectionUtils.getAllDeclaredMethods(bean.getClass())) {
            Trigger trigger;
            JobDetail jobDetail;
            QuartzScheduled annotation = (QuartzScheduled)AnnotationUtils.findAnnotation((Method)method, QuartzScheduled.class);
            if (annotation == null) continue;
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put("targetObject", beanName);
            jobDataMap.put("targetMethod", method.getName());
            String cron = annotation.cron();
            long fixedDelay = annotation.fixedDelay();
            long fixedRate = annotation.fixedRate();
            int initialDelay = (int)annotation.initialDelay();
            String jobDetailIdentity = beanName + "." + method.getName();
            if (cron != null && !"".equals(cron)) {
                cron = this.getCronExpression(cron);
                jobDetail = JobBuilder.newJob(ClusterQuartzJobBean.class).storeDurably(true).usingJobData(jobDataMap).build();
                trigger = TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey((String)jobDetailIdentity, (String)this.quartzProperties.getGroupName())).startAt(new Date(this.now.plusMillis(initialDelay).toEpochMilli())).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron).inTimeZone(this.quartzTimeZone)).build();
            } else if (fixedDelay > 0L) {
                jobDataMap.put("FIXED_DELAY_JOB_DATA", (Object)new FixedDelayJobData(fixedDelay));
                jobDetail = JobBuilder.newJob(ClusterQuartzFixedDelayJobBean.class).storeDurably(true).usingJobData(jobDataMap).build();
                trigger = TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey((String)jobDetailIdentity, (String)this.quartzProperties.getGroupName())).startAt(new Date(this.now.plusMillis(initialDelay).toEpochMilli())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(fixedDelay).repeatForever()).build();
            } else {
                jobDetail = JobBuilder.newJob(ClusterQuartzJobBean.class).storeDurably(true).usingJobData(jobDataMap).build();
                trigger = TriggerBuilder.newTrigger().withIdentity(TriggerKey.triggerKey((String)jobDetailIdentity, (String)this.quartzProperties.getGroupName())).startAt(new Date(this.now.plusMillis(initialDelay).toEpochMilli())).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(fixedRate).repeatForever()).build();
            }
            this.jobDetailTriggerMap.put(jobDetailIdentity, new JobDetailTrigger(jobDetail, trigger));
        }
        return bean;
    }

    private String getCronExpression(String cron) {
        if ((cron = cron.trim()).startsWith("${") && cron.endsWith("}")) {
            return this.applicationContext.getBeanFactory().resolveEmbeddedValue(cron);
        }
        return cron;
    }

    private List<JobKey> getJobKeys() throws SchedulerException {
        return new ArrayList<JobKey>(this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)this.quartzProperties.getGroupName())));
    }

    private List<TriggerKey> getTriggerKeys() throws SchedulerException {
        return new ArrayList<TriggerKey>(this.scheduler.getTriggerKeys(GroupMatcher.triggerGroupEquals((String)this.quartzProperties.getGroupName())));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.now = Instant.now();
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void run(ApplicationArguments args) throws Exception {
        try {
            if (!this.scheduler.isShutdown()) {
                Thread schedulerThread = new Thread(() -> {
                    try {
                        QuartzProperties quartzProperties = (QuartzProperties)this.applicationContext.getBean(QuartzProperties.class);
                        TimeUnit.SECONDS.sleep(quartzProperties.getStartupDelay().getSeconds());
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    try {
                        this.logger.info("reschedule all jobs...");
                        this.quartzManageService.rescheduleJobs(this.getJobKeys(), this.getTriggerKeys(), this.jobDetailTriggerMap);
                        this.scheduler.start();
                    }
                    catch (Exception ex) {
                        throw new SchedulingException("Could not start Quartz Scheduler after delay", (Throwable)ex);
                    }
                });
                schedulerThread.setName("Quartz Scheduler [" + this.scheduler.getSchedulerName() + "]");
                schedulerThread.setDaemon(true);
                schedulerThread.start();
            }
        }
        catch (SchedulerException e) {
            e.printStackTrace();
        }
    }
}

