/*
 * Copyright 2016 Fizzed, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.fizzed.crux.util;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

/**
 * Utilities related to security (e.g. TLS)
 * 
 * @author jjlauer
 */
public class SecureUtil {
    
    static public SSLSocketFactory createTrustAllSSLSocketFactory() throws UncheckedSecureException {
        TrustManager[] trustManagers = { TrustAllTrustManager.INSTANCE };
        return createSSLSocketFactory(trustManagers);
    }
    
    static public SSLSocketFactory createSSLSocketFactory(TrustManager[] trustManagers) throws UncheckedSecureException {
        try {
            final SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new java.security.SecureRandom());
            return sslContext.getSocketFactory();
        } catch (NoSuchAlgorithmException | KeyManagementException e) {
            throw new UncheckedSecureException(e.getMessage(), e);
        }
    }
    
    static public HostnameVerifier createTrustAllHostnameVerifier() throws UncheckedSecureException {
        return TrustAllHostnameVerifier.INSTANCE;
    }
    
}
