/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.Maybe;
import java.util.Comparator;
import java.util.Objects;

public class Agg {
    public static <V extends Comparable> Min<V> min() {
        Comparator comparator = Comparator.naturalOrder();
        return Agg.min(comparator, null);
    }

    public static <V extends Comparable> Min<V> min(Class<V> type) {
        Comparator comparator = Comparator.naturalOrder();
        return Agg.min(comparator, null);
    }

    public static <V extends Comparable> Min<V> min(V initialValue) {
        Comparator comparator = Comparator.naturalOrder();
        return Agg.min(comparator, initialValue);
    }

    public static <V> Min<V> min(Comparator<V> comparator) {
        return Agg.min(comparator, null);
    }

    public static <V> Min<V> min(Comparator<V> comparator, V initialValue) {
        return new Min<V>(comparator, initialValue);
    }

    public static <V extends Comparable> Max<V> max() {
        Comparator comparator = Comparator.naturalOrder();
        return Agg.max(comparator, null);
    }

    public static <V extends Comparable> Max<V> max(Class<V> type) {
        Comparator comparator = Comparator.naturalOrder();
        return Agg.max(comparator, null);
    }

    public static <V extends Comparable> Max<V> max(V initialValue) {
        Comparator comparator = Comparator.naturalOrder();
        return Agg.max(comparator, initialValue);
    }

    public static <V> Max<V> max(Comparator<V> comparator) {
        return Agg.max(comparator, null);
    }

    public static <V> Max<V> max(Comparator<V> comparator, V initialValue) {
        Objects.requireNonNull(comparator, "comparator was null");
        return new Max<V>(comparator.reversed(), initialValue);
    }

    public static class Max<T>
    extends OrderedValue<T> {
        protected Max(Comparator<? super T> comparator, T initialValue) {
            super(comparator, initialValue);
        }
    }

    public static class Min<T>
    extends OrderedValue<T> {
        protected Min(Comparator<? super T> comparator, T initialValue) {
            super(comparator, initialValue);
        }
    }

    public static class OrderedValue<T> {
        protected final Comparator<? super T> comparator;
        protected T value;

        protected OrderedValue(Comparator<? super T> comparator, T initialValue) {
            this.comparator = comparator;
            this.value = initialValue;
        }

        public boolean isAbsent() {
            return this.value == null;
        }

        public boolean isPresent() {
            return this.value != null;
        }

        public Maybe<T> maybe() {
            return Maybe.of(this.value);
        }

        public void clear() {
            this.value = null;
        }

        public void set(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        public boolean apply(T newValue) {
            return this.apply(newValue, false);
        }

        public boolean apply(T newValue, boolean includeNulls) {
            if (includeNulls || newValue != null) {
                if (!includeNulls && this.value == null) {
                    if (newValue != null) {
                        this.value = newValue;
                        return true;
                    }
                    return false;
                }
                int c = this.comparator.compare(this.value, newValue);
                if (c > 0) {
                    this.value = newValue;
                    return true;
                }
            }
            return false;
        }
    }
}

