/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

public class Base16 {
    public static String encode(byte[] bytes) {
        return Base16.encode(bytes, -1);
    }

    public static String encode(byte[] bytes, int maxLength) {
        return Base16.encode(bytes, false, maxLength);
    }

    public static String encode(byte[] bytes, boolean upper) {
        return Base16.encode(bytes, upper, -1);
    }

    public static String encode(byte[] bytes, boolean upper, int maxLength) {
        return Codec.encode(upper ? Codec.UPPER_CHARS : Codec.LOWER_CHARS, bytes, maxLength);
    }

    public static byte[] decode(String b16) {
        return Codec.decode(b16);
    }

    public static class Codec {
        private static final char[] LOWER_CHARS = "0123456789abcdef".toCharArray();
        private static final char[] UPPER_CHARS = "0123456789ABCDEF".toCharArray();

        public static int decodeChar(char c) {
            switch (c) {
                case '0': {
                    return 0;
                }
                case '1': {
                    return 1;
                }
                case '2': {
                    return 2;
                }
                case '3': {
                    return 3;
                }
                case '4': {
                    return 4;
                }
                case '5': {
                    return 5;
                }
                case '6': {
                    return 6;
                }
                case '7': {
                    return 7;
                }
                case '8': {
                    return 8;
                }
                case '9': {
                    return 9;
                }
                case 'A': 
                case 'a': {
                    return 10;
                }
                case 'B': 
                case 'b': {
                    return 11;
                }
                case 'C': 
                case 'c': {
                    return 12;
                }
                case 'D': 
                case 'd': {
                    return 13;
                }
                case 'E': 
                case 'e': {
                    return 14;
                }
                case 'F': 
                case 'f': {
                    return 15;
                }
            }
            throw new IllegalArgumentException("Invalid hex char " + c);
        }

        public static String encode(char[] encodeAlphabet, byte[] bytes) {
            if (bytes == null) {
                return null;
            }
            return Codec.encode(encodeAlphabet, bytes, bytes.length);
        }

        public static String encode(char[] encodeAlphabet, byte[] bytes, int maxLength) {
            int length;
            if (bytes == null) {
                return null;
            }
            int n = length = maxLength >= 0 && maxLength < bytes.length ? maxLength : bytes.length;
            if (length <= 0) {
                return "";
            }
            StringBuilder buf = new StringBuilder(2 * length);
            for (int i = 0; i < length; ++i) {
                buf.append(encodeAlphabet[0xF & bytes[i] >> 4]);
                buf.append(encodeAlphabet[0xF & bytes[i]]);
            }
            return buf.toString();
        }

        public static byte[] decode(String b16) {
            if (b16 == null) {
                return null;
            }
            int stringLength = b16.length();
            if (stringLength == 0) {
                return new byte[0];
            }
            if (stringLength % 2 != 0) {
                throw new IllegalArgumentException("Invalid length for hex string");
            }
            int byteLength = stringLength / 2;
            byte[] bytes = new byte[byteLength];
            for (int i = 0; i < byteLength; ++i) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | (0xF & Codec.decodeChar(b16.charAt(i * 2))) << 4);
                int n2 = i;
                bytes[n2] = (byte)(bytes[n2] | 0xF & Codec.decodeChar(b16.charAt(i * 2 + 1)));
            }
            return bytes;
        }
    }
}

