/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.ByteSizeUnit;
import java.text.DecimalFormat;
import java.util.Objects;

public class ByteSize
implements Comparable<ByteSize> {
    private final long value;
    private final ByteSizeUnit displayUnit;
    static final DecimalFormat FMT = new DecimalFormat("#.####");

    public ByteSize(long value) {
        this(value, ByteSizeUnit.B);
    }

    public ByteSize(long value, ByteSizeUnit displayUnit) {
        Objects.requireNonNull(displayUnit, "displayUnit was null");
        this.value = value;
        this.displayUnit = displayUnit;
    }

    public ByteSizeUnit getDisplayUnit() {
        return this.displayUnit;
    }

    public long getValue() {
        return this.value;
    }

    public ByteSize withDisplayUnit(ByteSizeUnit displayUnit) {
        return new ByteSize(this.value, displayUnit);
    }

    public double asDouble(ByteSizeUnit unit) {
        return unit.fromByteSize(this.value);
    }

    public long asLong(ByteSizeUnit unit) {
        return (long)unit.fromByteSize(this.value);
    }

    public String toString() {
        if (this.displayUnit == ByteSizeUnit.B) {
            return Long.toString(this.value);
        }
        double converted = this.displayUnit.fromByteSize(this.value);
        String s = FMT.format(converted);
        if (s.endsWith(".0")) {
            s = s.substring(0, s.length() - 2);
        }
        return s + this.displayUnit.getShortId();
    }

    @Override
    public int compareTo(ByteSize o) {
        return Long.compare(this.value, o.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ByteSize)) {
            return false;
        }
        ByteSize byteSize = (ByteSize)o;
        return this.value == byteSize.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public static ByteSize parse(String s) {
        return ByteSize.parse(s, ByteSizeUnit.B);
    }

    public static ByteSize parse(String s, ByteSizeUnit defaultUnit) {
        long value;
        String unitString;
        int digitStartPos = -1;
        int unitStartPos = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c) || c == '.') {
                if (digitStartPos >= 0) continue;
                digitStartPos = i;
                continue;
            }
            if (unitStartPos >= 0) continue;
            unitStartPos = i;
            break;
        }
        if (digitStartPos < 0) {
            throw new IllegalArgumentException("Value '" + s + "' does not contain any digits");
        }
        String digitString = s.substring(digitStartPos, unitStartPos < 0 ? s.length() : unitStartPos).trim();
        ByteSizeUnit displayUnit = defaultUnit;
        if (unitStartPos > 0 && (displayUnit = ByteSizeUnit.resolve(unitString = s.substring(unitStartPos).trim())) == null) {
            throw new IllegalArgumentException("The part '" + unitString + "' in value '" + s + "' is not a valid byte size unit");
        }
        if (digitString.contains(".")) {
            double size = Double.parseDouble(digitString);
            value = displayUnit.toByteSize(size);
        } else {
            long size = Long.parseLong(digitString);
            value = displayUnit.toByteSize(size);
        }
        return new ByteSize(value, displayUnit);
    }
}

