/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

public enum ByteSizeUnit {
    B("B", 1L),
    KiB("K", 1024L),
    MiB("M", 0x100000L),
    GiB("G", 0x40000000L),
    TiB("T", 0x10000000000L),
    PiB("P", 0x4000000000000L),
    EiB("E", 0x1000000000000000L);

    private final long multiplier;
    private final String shortId;

    private ByteSizeUnit(String shortId, long multiplier) {
        this.shortId = shortId;
        this.multiplier = multiplier;
    }

    public String getShortId() {
        return this.shortId;
    }

    public long getMultiplier() {
        return this.multiplier;
    }

    public long toByteSize(long size) {
        return size * this.multiplier;
    }

    public long toByteSize(double size) {
        return (long)(size * (double)this.multiplier);
    }

    public double fromByteSize(long byteSize) {
        return (double)byteSize / (double)this.multiplier;
    }

    public static ByteSizeUnit resolve(String unit) {
        if (unit != null) {
            for (ByteSizeUnit u : ByteSizeUnit.values()) {
                if (u.name().equalsIgnoreCase(unit)) {
                    return u;
                }
                if (!u.getShortId().equalsIgnoreCase(unit)) continue;
                return u;
            }
        }
        return null;
    }
}

