/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.JavaTimes;
import com.fizzed.crux.util.TimeDuration;
import java.time.Duration;
import java.time.Instant;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public class DateTimes {
    public static DateTime dateTime(Instant instant) {
        if (instant == null) {
            return null;
        }
        return new DateTime(instant.toEpochMilli(), DateTimeZone.UTC);
    }

    public static Instant javaInstant(DateTime dt) {
        if (dt == null) {
            return null;
        }
        return Instant.ofEpochMilli(dt.getMillis());
    }

    public static Duration javaDuration(org.joda.time.Duration duration) {
        if (duration == null) {
            return null;
        }
        return Duration.ofMillis(duration.getMillis());
    }

    public static DateTime now() {
        return DateTime.now((DateTimeZone)DateTimeZone.UTC);
    }

    public static DateTime utc(DateTime dt) {
        if (dt == null || dt.getZone() == DateTimeZone.UTC) {
            return dt;
        }
        return dt.withZone(DateTimeZone.UTC);
    }

    public static boolean equals(DateTime a, DateTime b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getMillis() == b.getMillis();
    }

    public static DateTime min(DateTime a, DateTime b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        return a.isAfter((ReadableInstant)b) ? b : a;
    }

    public static DateTime min(DateTime ... dts) {
        if (dts == null) {
            return null;
        }
        DateTime v = null;
        for (DateTime dt : dts) {
            v = DateTimes.min(v, dt);
        }
        return v;
    }

    public static DateTime max(DateTime a, DateTime b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        return a.isBefore((ReadableInstant)b) ? b : a;
    }

    public static DateTime max(DateTime ... dts) {
        if (dts == null) {
            return null;
        }
        DateTime v = null;
        for (DateTime dt : dts) {
            v = DateTimes.max(v, dt);
        }
        return v;
    }

    public static boolean gt(DateTime a, DateTime b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        return a.getMillis() > b.getMillis();
    }

    public static boolean gte(DateTime a, DateTime b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return true;
        }
        return a.getMillis() >= b.getMillis();
    }

    public static boolean lt(DateTime a, DateTime b) {
        if (b == null) {
            return false;
        }
        if (a == null) {
            return true;
        }
        return a.getMillis() < b.getMillis();
    }

    public static boolean lte(DateTime a, DateTime b) {
        if (b == null) {
            return a == null;
        }
        if (a == null) {
            return true;
        }
        return a.getMillis() <= b.getMillis();
    }

    public static TimeDuration age(DateTime dt) {
        return DateTimes.age(dt, System.currentTimeMillis());
    }

    public static TimeDuration age(DateTime dt, long epochMillis) {
        if (dt == null) {
            return null;
        }
        long ageMillis = epochMillis - dt.getMillis();
        return TimeDuration.millis(ageMillis);
    }

    public static boolean within(DateTime dt, DateTime start, DateTime end) {
        return DateTimes.within(dt, start, end, true, false);
    }

    public static boolean within(DateTime dt, DateTime start, DateTime end, boolean endInclusive) {
        return DateTimes.within(dt, start, end, true, endInclusive);
    }

    public static boolean within(DateTime dt, DateTime start, DateTime end, boolean startInclusive, boolean endInclusive) {
        if (dt == null) {
            return false;
        }
        DateTime _start = DateTimes.min(start, end);
        DateTime _end = DateTimes.max(start, end);
        if (startInclusive && DateTimes.lt(dt, _start)) {
            return false;
        }
        if (!startInclusive && DateTimes.lte(dt, _start)) {
            return false;
        }
        if (endInclusive && DateTimes.gt(dt, _end)) {
            return false;
        }
        return endInclusive || !DateTimes.gte(dt, _end);
    }

    public static String uptime(DateTime dt) {
        if (dt == null) {
            return null;
        }
        return JavaTimes.uptime(dt.getMillis());
    }

    public static String uptime(DateTime end, DateTime start) {
        if (end == null || start == null) {
            return null;
        }
        return JavaTimes.uptime(end.getMillis(), start.getMillis());
    }

    public static String uptime(org.joda.time.Duration duration) {
        if (duration == null) {
            return null;
        }
        return JavaTimes.uptime(DateTimes.javaDuration(duration));
    }
}

