/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.Base16;
import com.fizzed.crux.util.InOuts;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public abstract class Hasher {
    public abstract Hasher update(ByteBuffer var1);

    public abstract Hasher update(byte[] var1);

    public abstract Hasher update(byte[] var1, int var2, int var3);

    public abstract boolean isCompleted();

    public abstract byte[] asBytes();

    public abstract String asHex();

    public static Hasher md5() {
        return new Md5Hasher();
    }

    public static Hasher md5(File file) throws IOException {
        return Hasher.md5(file != null ? file.toPath() : null);
    }

    public static Hasher md5(Path file) throws IOException {
        try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
            Hasher hasher = Hasher.md5(input);
            return hasher;
        }
    }

    public static Hasher md5(InputStream input) throws IOException {
        Hasher hasher = Hasher.md5();
        Hasher.consume(hasher, input);
        return hasher;
    }

    private static void consume(Hasher hasher, InputStream input) throws IOException {
        InOuts.consume(input, (byte[] data, int read) -> hasher.update(data, 0, read));
    }

    static class Md5Hasher
    extends DigestHasher {
        public Md5Hasher() {
            super("MD5");
        }
    }

    static abstract class DigestHasher
    extends Hasher {
        protected final MessageDigest digest;
        protected byte[] hash;

        protected DigestHasher(String algorithm) {
            try {
                this.digest = MessageDigest.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }

        @Override
        public boolean isCompleted() {
            return this.hash != null;
        }

        protected void verifyNotCompleted() {
            if (this.isCompleted()) {
                throw new IllegalStateException("Hasher is completed and cannot be updated");
            }
        }

        @Override
        public Hasher update(ByteBuffer buffer) {
            this.verifyNotCompleted();
            this.digest.update(buffer);
            buffer.flip();
            return this;
        }

        @Override
        public Hasher update(byte[] buffer) {
            this.verifyNotCompleted();
            this.digest.update(buffer);
            return this;
        }

        @Override
        public Hasher update(byte[] buffer, int offset, int length) {
            this.verifyNotCompleted();
            this.digest.update(buffer, offset, length);
            return this;
        }

        @Override
        public byte[] asBytes() {
            if (this.hash == null) {
                this.hash = this.digest.digest();
            }
            return this.hash;
        }

        @Override
        public String asHex() {
            return Base16.encode(this.asBytes());
        }
    }
}

