/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class InOuts {
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static void close(InputStream input) throws IOException {
        if (input != null) {
            input.close();
        }
    }

    public static void close(OutputStream output) throws IOException {
        if (output != null) {
            output.close();
        }
    }

    public static void closeQuietly(InputStream input) {
        try {
            InOuts.close(input);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream output) {
        try {
            InOuts.close(output);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static byte[] bytes(InputStream input) throws IOException {
        return InOuts.bytes(input, true);
    }

    public static byte[] bytes(InputStream input, boolean close) throws IOException {
        try {
            byte[] byArray;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                InOuts.copy(input, output);
                byArray = output.toByteArray();
            }
            return byArray;
        }
        finally {
            if (close) {
                InOuts.close(input);
            }
        }
    }

    public static String string(InputStream input, Charset charset) throws IOException {
        return InOuts.string(input, charset, true);
    }

    public static String string(InputStream input, Charset charset, boolean close) throws IOException {
        byte[] bytes = InOuts.bytes(input, close);
        return new String(bytes, charset);
    }

    public static String stringUTF8(InputStream input) throws IOException {
        return InOuts.string(input, StandardCharsets.UTF_8, true);
    }

    public static String stringUTF8(InputStream input, boolean close) throws IOException {
        return InOuts.string(input, StandardCharsets.UTF_8, close);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return InOuts.copy(input, output, 2048);
    }

    public static long copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        long copied = InOuts.consume(input, bufferSize, (data, read) -> output.write(data, 0, read));
        output.flush();
        return copied;
    }

    public static long consume(InputStream input, ByteReadConsumer consumer) throws IOException {
        return InOuts.consume(input, 2048, consumer);
    }

    public static long consume(InputStream input, int bufferSize, ByteReadConsumer consumer) throws IOException {
        int read;
        long totalRead = 0L;
        byte[] buffer = new byte[bufferSize];
        while ((read = input.read(buffer, 0, buffer.length)) != -1) {
            totalRead += (long)read;
            consumer.apply(buffer, read);
        }
        return totalRead;
    }

    public static interface ByteReadConsumer {
        public void apply(byte[] var1, int var2) throws IOException;
    }
}

