/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.Maybe;
import java.time.Instant;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InstantInterval {
    private final Instant start;
    private final Instant end;

    public InstantInterval(Instant start) {
        this(start, null);
    }

    public InstantInterval(Instant start, Instant end) {
        Objects.requireNonNull(start);
        this.start = start;
        this.end = Maybe.maybe(end).orElse(Instant.now());
    }

    public Instant getStart() {
        return this.start;
    }

    public Instant getEnd() {
        return this.end;
    }

    public List<InstantInterval> partition(long temporalDuration, TemporalUnit temporalUnit) {
        Instant to;
        ArrayList<InstantInterval> intervals = new ArrayList<InstantInterval>();
        Instant from = this.end;
        do {
            if ((to = from.minus(temporalDuration, temporalUnit)).isBefore(this.start)) {
                to = this.start;
            }
            intervals.add(new InstantInterval(to, from));
            from = to;
        } while (to.isAfter(this.start));
        return intervals;
    }

    public String toString() {
        return "Interval{start=" + this.start + ", end=" + this.end + '}';
    }
}

