/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.TimeDuration;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

public class JavaTimes {
    public static ZonedDateTime zonedDateTime(Instant instant) {
        if (instant == null) {
            return null;
        }
        return ZonedDateTime.ofInstant(instant, ZoneOffset.UTC);
    }

    public static ZonedDateTime now() {
        return ZonedDateTime.now(ZoneOffset.UTC);
    }

    public static boolean equals(ZonedDateTime a, ZonedDateTime b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.toInstant().equals(b.toInstant());
    }

    public static boolean sameMillisPrecision(Instant a, Instant b, boolean rounding) {
        Instant actualTruncated;
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Instant expectedTruncated = b.truncatedTo(ChronoUnit.MILLIS);
        if (expectedTruncated.equals(actualTruncated = a.truncatedTo(ChronoUnit.MILLIS))) {
            return true;
        }
        if (rounding) {
            int expectedNanoOfSecond = b.get(ChronoField.NANO_OF_SECOND);
            int actualNanoOfSecond = a.get(ChronoField.NANO_OF_SECOND);
            int expectedNanoRemains = expectedNanoOfSecond - expectedNanoOfSecond / 1000000 * 1000000;
            int actualNanoRemains = actualNanoOfSecond - actualNanoOfSecond / 1000000 * 1000000;
            Instant expectedPlus1 = expectedTruncated.plusMillis(1L);
            Instant actualPlus1 = actualTruncated.plusMillis(1L);
            if (expectedNanoRemains >= 500000) {
                if (expectedPlus1.equals(actualTruncated)) {
                    return true;
                }
                if (actualNanoRemains >= 500000 && expectedPlus1.equals(actualPlus1)) {
                    return true;
                }
            }
            if (actualNanoRemains >= 500000) {
                if (actualPlus1.equals(expectedTruncated)) {
                    return true;
                }
                if (expectedNanoRemains >= 500000 && actualPlus1.equals(expectedPlus1)) {
                    return true;
                }
            }
        }
        return false;
    }

    public static TimeDuration age(Instant instant) {
        return JavaTimes.age(instant, System.currentTimeMillis());
    }

    public static TimeDuration age(ZonedDateTime dt) {
        return JavaTimes.age(dt, System.currentTimeMillis());
    }

    public static TimeDuration age(Instant instant, long epochMillis) {
        if (instant == null) {
            return null;
        }
        long ageMillis = epochMillis - instant.toEpochMilli();
        return TimeDuration.millis(ageMillis);
    }

    public static TimeDuration age(ZonedDateTime dt, long epochMillis) {
        if (dt == null) {
            return null;
        }
        return JavaTimes.age(dt.toInstant(), epochMillis);
    }

    public static String uptime(Instant start) {
        if (start == null) {
            return null;
        }
        return JavaTimes.uptime(System.currentTimeMillis(), start.toEpochMilli());
    }

    public static String uptime(Long startEpochMillis) {
        if (startEpochMillis == null) {
            return null;
        }
        return JavaTimes.uptime(System.currentTimeMillis(), startEpochMillis);
    }

    public static String uptime(ZonedDateTime start) {
        if (start == null) {
            return null;
        }
        return JavaTimes.uptime(start.toInstant());
    }

    public static String uptime(ZonedDateTime end, ZonedDateTime start) {
        if (end == null || start == null) {
            return null;
        }
        return JavaTimes.uptime(end.toInstant(), start.toInstant());
    }

    public static String uptime(Instant end, Instant start) {
        if (end == null || start == null) {
            return null;
        }
        return JavaTimes.uptime(end.toEpochMilli(), start.toEpochMilli());
    }

    public static String uptime(Long endEpochMillis, Long startEpochMillis) {
        if (endEpochMillis == null || startEpochMillis == null) {
            return null;
        }
        return JavaTimes.uptime(Duration.ofMillis(endEpochMillis - startEpochMillis));
    }

    public static String uptime(Duration duration) {
        if (duration == null) {
            return null;
        }
        long days = duration.toDays();
        long hours = duration.toHours() % 24L;
        long mins = duration.toMinutes() % 60L;
        long secs = duration.getSeconds() % 60L;
        long ms = TimeUnit.MILLISECONDS.convert(duration.getNano(), TimeUnit.NANOSECONDS);
        StringBuilder sb = new StringBuilder();
        if (days != 0L) {
            sb.append(days).append("d");
        }
        if (hours != 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(hours).append("h");
        }
        if (mins != 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(mins).append("m");
        }
        if (secs != 0L) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(secs).append("s");
        }
        if (ms != 0L || sb.length() == 0) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(ms).append("ms");
        }
        return sb.toString();
    }

    public static Instant min(Instant a, Instant b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        return a.isAfter(b) ? b : a;
    }

    public static Instant min(Instant ... dts) {
        if (dts == null) {
            return null;
        }
        Instant v = null;
        for (Instant dt : dts) {
            v = JavaTimes.min(v, dt);
        }
        return v;
    }

    public static Instant max(Instant a, Instant b) {
        if (b == null) {
            return a;
        }
        if (a == null) {
            return b;
        }
        return a.isBefore(b) ? b : a;
    }

    public static Instant max(Instant ... dts) {
        if (dts == null) {
            return null;
        }
        Instant v = null;
        for (Instant dt : dts) {
            v = JavaTimes.max(v, dt);
        }
        return v;
    }

    public static boolean gt(Instant a, Instant b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        return a.isAfter(b);
    }

    public static boolean gte(Instant a, Instant b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return true;
        }
        return a.compareTo(b) >= 0;
    }

    public static boolean lt(Instant a, Instant b) {
        if (b == null) {
            return false;
        }
        if (a == null) {
            return true;
        }
        return a.isBefore(b);
    }

    public static boolean lte(Instant a, Instant b) {
        if (b == null) {
            return a == null;
        }
        if (a == null) {
            return true;
        }
        return a.compareTo(b) <= 0;
    }

    public static boolean within(Instant dt, Instant start, Instant end) {
        return JavaTimes.within(dt, start, end, true, false);
    }

    public static boolean within(Instant dt, Instant start, Instant end, boolean endInclusive) {
        return JavaTimes.within(dt, start, end, true, endInclusive);
    }

    public static boolean within(Instant dt, Instant start, Instant end, boolean startInclusive, boolean endInclusive) {
        if (dt == null) {
            return false;
        }
        Instant _start = JavaTimes.min(start, end);
        Instant _end = JavaTimes.max(start, end);
        if (startInclusive && JavaTimes.lt(dt, _start)) {
            return false;
        }
        if (!startInclusive && JavaTimes.lte(dt, _start)) {
            return false;
        }
        if (endInclusive && JavaTimes.gt(dt, _end)) {
            return false;
        }
        return endInclusive || !JavaTimes.gte(dt, _end);
    }

    public static boolean overlap(Instant start1, Instant end1, Instant start2, Instant end2) {
        return JavaTimes.overlap(start1, end1, start2, end2, true, false);
    }

    public static boolean overlap(Instant start1, Instant end1, Instant start2, Instant end2, boolean endInclusive) {
        return JavaTimes.overlap(start1, end1, start2, end2, true, endInclusive);
    }

    public static boolean overlap(Instant start1, Instant end1, Instant start2, Instant end2, boolean startInclusive, boolean endInclusive) {
        Instant range2End;
        if (end1 == null && end2 == null) {
            return true;
        }
        if (start1 == null && start2 == null) {
            return true;
        }
        Instant range1Start = start1 == null ? Instant.MIN : start1;
        Instant range1End = end1 == null ? Instant.MAX : end1;
        Instant range2Start = start2 == null ? Instant.MIN : start2;
        Instant instant = range2End = end2 == null ? Instant.MAX : end2;
        if (JavaTimes.lt(range2Start, range1Start)) {
            Instant temp1 = range1Start;
            Instant temp2 = range1End;
            range1Start = range2Start;
            range1End = range2End;
            range2Start = temp1;
            range2End = temp2;
        }
        boolean range1EndsBeforeRange2Starts = endInclusive ? JavaTimes.lt(range1End, range2Start) : JavaTimes.lte(range1End, range2Start);
        boolean range1StartsAfterRange2Ends = startInclusive ? JavaTimes.gt(range1Start, range2End) : JavaTimes.gte(range1Start, range2End);
        return !range1EndsBeforeRange2Starts && !range1StartsAfterRange2Ends;
    }
}

