/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.TimeDuration;
import java.time.Duration;
import java.util.function.Consumer;

public class RunEvery {
    private final long everyMillis;
    private long lastRunTime;

    public RunEvery(long everyMillis) {
        this.everyMillis = everyMillis;
        this.lastRunTime = System.currentTimeMillis();
    }

    public static RunEvery runEvery(long everyMillis) {
        return new RunEvery(everyMillis);
    }

    public static RunEvery runEvery(Duration everyDuration) {
        return new RunEvery(everyDuration.toMillis());
    }

    public static RunEvery runEvery(TimeDuration everyDuration) {
        return new RunEvery(everyDuration.asMillis());
    }

    public boolean isRunnable() {
        return System.currentTimeMillis() - this.lastRunTime >= this.everyMillis;
    }

    public void ifRunnable(Runnable runnable) {
        if (this.isRunnable()) {
            runnable.run();
            this.lastRunTime = System.currentTimeMillis();
        }
    }

    public void ifRunnable(Consumer<Long> runnable) {
        if (this.isRunnable()) {
            runnable.accept(this.lastRunTime);
            this.lastRunTime = System.currentTimeMillis();
        }
    }
}

