/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class StopWatch {
    private final TimeUnit tu;
    private final long start;
    private long stop;
    private boolean stopped;

    public StopWatch() {
        this(TimeUnit.MILLISECONDS, System.nanoTime(), -1L, false);
    }

    public StopWatch(TimeUnit tu) {
        this(tu, System.nanoTime(), -1L, false);
        Objects.requireNonNull(tu, "time unit was null");
    }

    StopWatch(TimeUnit tu, long start, long stop, boolean stopped) {
        this.tu = tu;
        this.start = start;
        this.stop = stop;
        this.stopped = stopped;
    }

    public boolean isRunning() {
        return !this.stopped;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public StopWatch stop() {
        if (this.isRunning()) {
            this.stop = System.nanoTime();
            this.stopped = true;
        }
        return this;
    }

    public static StopWatch timeMillis() {
        return new StopWatch(TimeUnit.MILLISECONDS);
    }

    public static StopWatch timeMillis(Runnable runnable) {
        return StopWatch.time(TimeUnit.MILLISECONDS, runnable);
    }

    public static StopWatch timeNanos() {
        return new StopWatch(TimeUnit.NANOSECONDS);
    }

    public static StopWatch timeNanos(Runnable runnable) {
        return StopWatch.time(TimeUnit.NANOSECONDS, runnable);
    }

    public static StopWatch timeSeconds() {
        return new StopWatch(TimeUnit.SECONDS);
    }

    public static StopWatch timeSeconds(Runnable runnable) {
        return StopWatch.time(TimeUnit.SECONDS, runnable);
    }

    public static StopWatch time(TimeUnit tu) {
        return new StopWatch(tu);
    }

    public static StopWatch time(TimeUnit tu, Runnable runnable) {
        StopWatch watch = new StopWatch(tu);
        try {
            runnable.run();
        }
        finally {
            watch.stop();
        }
        return watch;
    }

    public double elapsed() {
        return this.elapsed(this.tu);
    }

    public double elapsed(TimeUnit tu) {
        switch (tu) {
            case NANOSECONDS: {
                return this.elapsedNanos();
            }
            case MICROSECONDS: {
                return this.elapsedMicros();
            }
            case MILLISECONDS: {
                return this.elapsedMillis();
            }
            case SECONDS: {
                return this.elapsedSeconds();
            }
            case MINUTES: {
                return this.elapsedMinutes();
            }
            case HOURS: {
                return this.elapsedHours();
            }
            case DAYS: {
                return this.elapsedDays();
            }
        }
        throw new UnsupportedOperationException("Unable to handle time unit " + (Object)((Object)tu));
    }

    public boolean eq(double duration) {
        return this.elapsed() == duration;
    }

    public boolean gt(double duration) {
        return this.elapsed() > duration;
    }

    public boolean gte(double duration) {
        return this.elapsed() >= duration;
    }

    public boolean lt(double duration) {
        return this.elapsed() < duration;
    }

    public boolean lte(double duration) {
        return this.elapsed() <= duration;
    }

    public long elapsedNanos() {
        if (this.stopped) {
            return this.stop - this.start;
        }
        return System.nanoTime() - this.start;
    }

    public double elapsedMicros() {
        return (double)this.elapsedNanos() / 1000.0;
    }

    public double elapsedMillis() {
        return (double)this.elapsedNanos() / 1000000.0;
    }

    public double elapsedSeconds() {
        return (double)this.elapsedNanos() / 1.0E9;
    }

    public double elapsedMinutes() {
        return this.elapsedSeconds() / 60.0;
    }

    public double elapsedHours() {
        return this.elapsedMinutes() / 60.0;
    }

    public double elapsedDays() {
        return this.elapsedHours() / 24.0;
    }

    public String toString() {
        return this.toString(this.tu);
    }

    public String toString(TimeUnit tu) {
        Objects.requireNonNull(tu, "time unit was null");
        switch (tu) {
            case NANOSECONDS: {
                return String.format("%d ns", this.elapsedNanos());
            }
            case MICROSECONDS: {
                return String.format("%.0f mu", this.elapsedMicros());
            }
            case SECONDS: {
                return String.format("%.2f s", this.elapsedSeconds());
            }
            case MINUTES: {
                return String.format("%.2f m", this.elapsedMinutes());
            }
            case HOURS: {
                return String.format("%.2f h", this.elapsedHours());
            }
            case DAYS: {
                return String.format("%.2f d", this.elapsedDays());
            }
        }
        return String.format("%.1f ms", this.elapsedMillis());
    }
}

