/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class TextTable {
    private List<Column> columns = new ArrayList<Column>();
    private List<Object[]> rows = new ArrayList<Object[]>();
    private int columnPadding = 1;
    private char columnSeparator = '\u0000';

    public int getColumnPadding() {
        return this.columnPadding;
    }

    public TextTable setColumnPadding(int columnPadding) {
        this.columnPadding = columnPadding;
        return this;
    }

    public char getColumnSeparator() {
        return this.columnSeparator;
    }

    public TextTable setColumnSeparator(char columnSeparator) {
        this.columnSeparator = columnSeparator;
        return this;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public TextTable setColumns(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public List<Object[]> getRows() {
        return this.rows;
    }

    public TextTable setRows(List<Object[]> rows) {
        this.rows = rows;
        return this;
    }

    public int renderWidth() {
        int width = 0;
        for (Column c : this.columns) {
            width += c.getWidth();
        }
        if (this.columnSeparator > '\u0000') {
            width += (this.columns.size() - 1) * (this.columnPadding + 1 + this.columnPadding);
            width += (1 + this.columnPadding) * 2;
        } else {
            width += (this.columns.size() - 1) * this.columnPadding;
        }
        return width;
    }

    public List<String> renderLines() {
        ArrayList<String> lines = new ArrayList<String>(2 + this.rows.size());
        this.render(lines::add);
        return lines;
    }

    public String renderHeader() {
        StringBuilder sb = new StringBuilder();
        this.renderHeader(sb);
        return sb.toString();
    }

    public void renderHeader(StringBuilder sb) {
        this.renderRow(sb, ' ', this.columns.toArray());
    }

    public String renderHeaderSeparator() {
        StringBuilder sb = new StringBuilder();
        this.renderHeaderSeparator(sb);
        return sb.toString();
    }

    public void renderHeaderSeparator(StringBuilder sb) {
        Object[] headerSeparatorRow = new String[this.columns.size()];
        for (int i = 0; i < this.columns.size(); ++i) {
            headerSeparatorRow[i] = "";
        }
        this.renderRow(sb, '-', headerSeparatorRow);
    }

    public String renderRow(Object ... row) {
        StringBuilder sb = new StringBuilder();
        this.renderRow(sb, row);
        return sb.toString();
    }

    public void renderRow(StringBuilder sb, Object ... row) {
        this.renderRow(sb, ' ', row);
    }

    public void render(Consumer<String> lineConsumer) {
        int renderWidth = this.renderWidth();
        StringBuilder sb = new StringBuilder();
        this.renderHeader(sb);
        lineConsumer.accept(sb.toString());
        sb.setLength(0);
        this.renderHeaderSeparator(sb);
        lineConsumer.accept(sb.toString());
        for (Object[] row : this.rows) {
            sb.setLength(0);
            this.renderRow(sb, ' ', row);
            lineConsumer.accept(sb.toString());
        }
    }

    private void renderRow(StringBuilder sb, char paddingChar, Object[] row) {
        if (this.columnSeparator > '\u0000') {
            sb.append(this.columnSeparator);
            TextTable.repeat(sb, paddingChar, this.columnPadding);
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            String o;
            if (i > 0) {
                if (this.columnSeparator > '\u0000') {
                    TextTable.repeat(sb, paddingChar, this.columnPadding);
                    sb.append(this.columnSeparator);
                    TextTable.repeat(sb, paddingChar, this.columnPadding);
                } else {
                    TextTable.repeat(sb, paddingChar, this.columnPadding);
                }
            }
            Column c = this.columns.get(i);
            String string = o = row.length > i ? row[i] : "";
            if (c.align == null || c.align == Align.LEFT) {
                TextTable.rightPad(sb, Objects.toString(o), c.getWidth(), paddingChar);
                continue;
            }
            if (c.align == Align.RIGHT) {
                TextTable.leftPad(sb, Objects.toString(o), c.getWidth(), paddingChar);
                continue;
            }
            if (c.align != Align.CENTER) continue;
            TextTable.centerPad(sb, Objects.toString(o), c.getWidth(), paddingChar);
        }
        if (this.columnSeparator > '\u0000') {
            TextTable.repeat(sb, paddingChar, this.columnPadding);
            sb.append(this.columnSeparator);
        }
    }

    public TextTable addColumn(Column column) {
        this.columns.add(column);
        return this;
    }

    public TextTable addColumns(Column ... columns) {
        for (Column c : columns) {
            this.addColumn(c);
        }
        return this;
    }

    public TextTable addRow(Object ... row) {
        this.rows.add(row);
        return this;
    }

    public static void repeat(StringBuilder sb, char repeatChar, int count) {
        for (int i = 0; i < count; ++i) {
            sb.append(repeatChar);
        }
    }

    public static void rightPad(StringBuilder sb, String str, int size, char padChar) {
        if (str == null) {
            return;
        }
        if (str.length() > size) {
            sb.append(str.substring(0, size));
        } else {
            int padCount = size - str.length();
            sb.append(str);
            TextTable.repeat(sb, padChar, padCount);
        }
    }

    public static void leftPad(StringBuilder sb, String str, int size, char padChar) {
        if (str == null) {
            return;
        }
        if (str.length() > size) {
            sb.append(str.substring(0, size));
        } else {
            int padCount = size - str.length();
            TextTable.repeat(sb, padChar, padCount);
            sb.append(str);
        }
    }

    public static void centerPad(StringBuilder sb, String str, int size, char padChar) {
        if (str == null) {
            return;
        }
        if (str.length() > size) {
            sb.append(str.substring(0, size));
        } else {
            int padCount = size - str.length();
            int padLeftCount = padCount / 2;
            int padRightCount = padCount - padLeftCount;
            TextTable.repeat(sb, padChar, padLeftCount);
            sb.append(str);
            TextTable.repeat(sb, padChar, padRightCount);
        }
    }

    public static class Column {
        private String name;
        private Align align;
        private int width;

        public String getName() {
            return this.name;
        }

        public Column setName(String name) {
            this.name = name;
            return this;
        }

        public Align getAlign() {
            return this.align;
        }

        public Column setAlign(Align align) {
            this.align = align;
            return this;
        }

        public int getWidth() {
            return this.width;
        }

        public Column setWidth(int width) {
            this.width = width;
            return this;
        }

        public String toString() {
            return this.name;
        }

        public static Column column(String name, Align align, int width) {
            return new Column().setName(name).setAlign(align).setWidth(width);
        }
    }

    public static enum Align {
        LEFT,
        CENTER,
        RIGHT;

    }
}

