/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactoryBuilder {
    private String name;
    private Boolean daemon;

    public ThreadFactoryBuilder(String name) {
        this(name, null);
    }

    public ThreadFactoryBuilder(String name, Boolean daemon) {
        this.name = name;
        this.daemon = daemon;
    }

    public ThreadFactoryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ThreadFactoryBuilder setDaemon(Boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadFactory build() {
        return new ThreadFactory(){
            private final AtomicInteger sequence = new AtomicInteger();

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setName(ThreadFactoryBuilder.this.name + "-" + this.sequence.getAndIncrement());
                if (ThreadFactoryBuilder.this.daemon != null) {
                    thread.setDaemon(ThreadFactoryBuilder.this.daemon);
                }
                return thread;
            }
        };
    }
}

