/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import com.fizzed.crux.util.MoreComparable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TimeDuration
implements MoreComparable<TimeDuration> {
    private final long duration;
    private final TimeUnit unit;

    public TimeDuration(long duration, TimeUnit unit) {
        this.duration = duration;
        this.unit = unit;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public TimeDuration toNanos() {
        if (this.unit == TimeUnit.NANOSECONDS) {
            return this;
        }
        return new TimeDuration(this.unit.toNanos(this.duration), TimeUnit.NANOSECONDS);
    }

    public TimeDuration toMillis() {
        if (this.unit == TimeUnit.MILLISECONDS) {
            return this;
        }
        return new TimeDuration(this.unit.toMillis(this.duration), TimeUnit.MILLISECONDS);
    }

    public TimeDuration toSeconds() {
        if (this.unit == TimeUnit.SECONDS) {
            return this;
        }
        return new TimeDuration(this.unit.toSeconds(this.duration), TimeUnit.SECONDS);
    }

    public TimeDuration toMinutes() {
        if (this.unit == TimeUnit.MINUTES) {
            return this;
        }
        return new TimeDuration(this.unit.toMinutes(this.duration), TimeUnit.MINUTES);
    }

    public TimeDuration toHours() {
        if (this.unit == TimeUnit.HOURS) {
            return this;
        }
        return new TimeDuration(this.unit.toHours(this.duration), TimeUnit.HOURS);
    }

    public TimeDuration toDays() {
        if (this.unit == TimeUnit.DAYS) {
            return this;
        }
        return new TimeDuration(this.unit.toDays(this.duration), TimeUnit.DAYS);
    }

    public boolean isZero() {
        return this.duration == 0L;
    }

    public void sleep() throws InterruptedException {
        Thread.sleep(this.asMillis());
    }

    public long asNanos() {
        return this.toNanos().getDuration();
    }

    public long asMillis() {
        return this.toMillis().getDuration();
    }

    public long asSeconds() {
        return this.toSeconds().getDuration();
    }

    public long asMinutes() {
        return this.toMinutes().getDuration();
    }

    public long asHours() {
        return this.toHours().getDuration();
    }

    public long asDays() {
        return this.toDays().getDuration();
    }

    public String toString() {
        return this.duration + TimeDuration.toShort(this.unit);
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (int)(this.duration ^ this.duration >>> 32);
        hash = 83 * hash + Objects.hashCode((Object)this.unit);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeDuration other = (TimeDuration)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(TimeDuration o) {
        if (this.unit == o.unit) {
            return Long.compare(this.duration, o.duration);
        }
        return Long.compare(this.asNanos(), o.asNanos());
    }

    public static String toShort(TimeUnit timeUnit) {
        if (timeUnit != null) {
            switch (timeUnit) {
                case DAYS: {
                    return "d";
                }
                case HOURS: {
                    return "h";
                }
                case MINUTES: {
                    return "m";
                }
                case SECONDS: {
                    return "s";
                }
                case MILLISECONDS: {
                    return "ms";
                }
                case NANOSECONDS: {
                    return "ns";
                }
            }
        }
        return null;
    }

    public static TimeUnit fromShort(String value) {
        if (value != null) {
            switch (value) {
                case "D": 
                case "d": {
                    return TimeUnit.DAYS;
                }
                case "H": 
                case "h": {
                    return TimeUnit.HOURS;
                }
                case "M": 
                case "m": {
                    return TimeUnit.MINUTES;
                }
                case "S": 
                case "s": {
                    return TimeUnit.SECONDS;
                }
                case "MS": 
                case "ms": 
                case "Ms": 
                case "mS": {
                    return TimeUnit.MILLISECONDS;
                }
                case "NS": 
                case "ns": 
                case "Ns": 
                case "nS": {
                    return TimeUnit.NANOSECONDS;
                }
            }
        }
        return null;
    }

    public static TimeDuration parse(String value) {
        return TimeDuration.parse(value, null);
    }

    public static TimeDuration parse(String value, TimeUnit defaultUnit) {
        long duration;
        TimeUnit unit;
        int durationLength;
        if (value == null || value.isEmpty()) {
            return null;
        }
        for (durationLength = value.length(); durationLength > 0 && !Character.isDigit(value.charAt(durationLength - 1)); --durationLength) {
        }
        int unitLength = value.length() - durationLength;
        if (unitLength <= 0 && defaultUnit == null) {
            throw new IllegalArgumentException("No unit specified on time duration '" + value + "'");
        }
        if (unitLength > 2) {
            throw new IllegalArgumentException("Invalid unit specified on time duration '" + value + "'");
        }
        if (durationLength <= 0) {
            throw new IllegalArgumentException("No duration specified on time duration '" + value + "'");
        }
        if (unitLength <= 0) {
            unit = defaultUnit;
        } else {
            String _unit = value.substring(durationLength);
            unit = TimeDuration.fromShort(_unit);
            if (unit == null) {
                throw new IllegalArgumentException("Unsupported unit '" + _unit + "' specified on time duration '" + value + "'");
            }
        }
        String _duration = value.substring(0, durationLength);
        try {
            duration = Long.parseLong(_duration);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Duration '" + _duration + "' is not a long value on time duration '" + value + "'");
        }
        return new TimeDuration(duration, unit);
    }

    public static TimeDuration nanos(long durationNanos) {
        return new TimeDuration(durationNanos, TimeUnit.NANOSECONDS);
    }

    public static TimeDuration millis(long durationMillis) {
        return new TimeDuration(durationMillis, TimeUnit.MILLISECONDS);
    }

    public static TimeDuration seconds(long durationSeconds) {
        return new TimeDuration(durationSeconds, TimeUnit.SECONDS);
    }

    public static TimeDuration minutes(long durationMinutes) {
        return new TimeDuration(durationMinutes, TimeUnit.MINUTES);
    }

    public static TimeDuration hours(long durationHours) {
        return new TimeDuration(durationHours, TimeUnit.HOURS);
    }

    public static TimeDuration days(long durationDays) {
        return new TimeDuration(durationDays, TimeUnit.DAYS);
    }
}

