/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.crux.util;

import java.util.Objects;

public class ToStringBuilder {
    private final String fieldDelimiter;
    private final String valueDelimiter;
    private StringBuilder sb;

    public ToStringBuilder() {
        this(", ", "=");
    }

    public ToStringBuilder(String fieldDelimiter) {
        this(fieldDelimiter, "=");
    }

    public ToStringBuilder(String fieldDelimiter, String valueDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
        this.valueDelimiter = valueDelimiter;
    }

    public String toString() {
        if (this.sb != null) {
            return this.sb.toString();
        }
        return null;
    }

    public ToStringBuilder nb(Object value) {
        String s = Objects.toString(value, null);
        if (s != null && !s.isEmpty() && !s.trim().isEmpty()) {
            this.a(s);
        }
        return this;
    }

    public ToStringBuilder nn(Object value) {
        if (value != null) {
            this.a(value);
        }
        return this;
    }

    public ToStringBuilder a(Object value) {
        if (this.sb == null) {
            this.sb = new StringBuilder();
        }
        this.sb.append(value);
        return this;
    }

    public ToStringBuilder a(ToStringBuilder other) {
        if (other != null && other.sb != null) {
            if (this.sb == null) {
                this.sb = new StringBuilder();
            }
            this.sb.append((CharSequence)other.sb);
        }
        return this;
    }

    public ToStringBuilder nb(String fieldName, Object fieldValue) {
        String s = Objects.toString(fieldValue, null);
        if (s != null && !s.isEmpty() && !s.trim().isEmpty()) {
            this.a(fieldName, s);
        }
        return this;
    }

    public ToStringBuilder nn(String fieldName, Object fieldValue) {
        if (fieldValue != null) {
            this.a(fieldName, fieldValue);
        }
        return this;
    }

    public ToStringBuilder a(String fieldName, Object fieldValue) {
        if (this.sb == null) {
            this.sb = new StringBuilder();
        } else if (this.sb.length() > 0) {
            this.sb.append(this.fieldDelimiter);
        }
        this.sb.append(fieldName);
        if (this.valueDelimiter != null) {
            this.sb.append(this.valueDelimiter);
        }
        this.sb.append(Objects.toString(fieldValue, null));
        return this;
    }
}

