/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.launcher;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fizzed.stork.launcher.Configuration;
import com.fizzed.stork.launcher.JacksonUtil;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ConfigurationFactory {
    private ObjectMapper mapper = ConfigurationFactory.createObjectMapper();

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        return mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public JsonNode createDefaultNode() {
        return this.mapper.valueToTree((Object)new Configuration());
    }

    public JsonNode createConfigNode(File configFile) throws IOException {
        return this.mapper.readTree(configFile);
    }

    public JsonNode mergeNodes(JsonNode node, JsonNode updateNode) {
        return JacksonUtil.merge(node, updateNode);
    }

    public Configuration create(JsonNode node) throws JsonProcessingException {
        return (Configuration)this.mapper.treeToValue((TreeNode)node, Configuration.class);
    }

    public Configuration create(File configFile) throws Exception {
        Iterator iterator;
        JsonNode defaultNode = this.createDefaultNode();
        JsonNode configNode = this.createConfigNode(configFile);
        JsonNode mergedNode = this.mergeNodes(defaultNode, configNode);
        Configuration config = this.create(mergedNode);
        config.setFile(configFile);
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        Set violations = validator.validate((Object)config, new Class[0]);
        if (violations.size() > 0 && (iterator = violations.iterator()).hasNext()) {
            ConstraintViolation violation = (ConstraintViolation)iterator.next();
            throw new Exception("Configuration file invalid: property [" + violation.getPropertyPath() + "] error [" + violation.getMessage() + "]");
        }
        return config;
    }
}

