/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.launcher;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.filefilter.WildcardFileFilter;

public class FileUtil {
    public static List<File> findAllFiles(List<String> fileStrings, boolean ignoreNonExistent) throws IOException {
        ArrayList<File> allFiles = new ArrayList<File>();
        for (String fileString : fileStrings) {
            List<File> files = FileUtil.findFiles(fileString, ignoreNonExistent);
            allFiles.addAll(files);
        }
        return allFiles;
    }

    public static List<File> findFiles(String fileString, boolean ignoreNonExistent) throws IOException {
        if (fileString.endsWith("*")) {
            File f = new File(fileString);
            File parent = f.getParentFile();
            if (parent == null) {
                parent = new File(".");
            }
            WildcardFileFilter fileFilter = new WildcardFileFilter(f.getName());
            File[] files = parent.listFiles((FileFilter)fileFilter);
            return Arrays.asList(files);
        }
        File f = new File(fileString);
        if (!f.exists()) {
            if (ignoreNonExistent) {
                return Collections.EMPTY_LIST;
            }
            throw new IOException("File [" + fileString + "] does not exist");
        }
        if (f.isDirectory()) {
            return Arrays.asList(f.listFiles());
        }
        return Arrays.asList(f);
    }
}

