/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.launcher;

import com.fizzed.stork.launcher.ArgumentException;
import com.fizzed.stork.launcher.Configuration;
import com.fizzed.stork.launcher.ConfigurationFactory;
import com.fizzed.stork.launcher.LauncherModel;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Generator {
    private static final Logger logger = LoggerFactory.getLogger(Generator.class);
    private final ConfigurationFactory factory = new ConfigurationFactory();
    private static freemarker.template.Configuration fmconfig;

    public Configuration readConfigurationFile(File configFile) throws ArgumentException, IOException {
        List<Configuration> configs = this.readConfigurationFiles(Arrays.asList(configFile));
        if (configs.size() != 1) {
            throw new IOException("Unexpected number of configs returned (expected 1 but got " + configs.size() + ")");
        }
        return configs.get(0);
    }

    public List<Configuration> readConfigurationFiles(List<File> configFiles) throws ArgumentException, IOException {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        if (configFiles == null || configFiles.isEmpty()) {
            return configs;
        }
        for (File configFile : configFiles) {
            try {
                configs.add(this.factory.create(configFile));
            }
            catch (Exception e) {
                throw new IOException("Launcher config file [" + configFile + "] failed parsing", e);
            }
        }
        return configs;
    }

    public int generate(File configFile, File outputDir) throws ArgumentException, IOException {
        List<Configuration> configs = this.readConfigurationFiles(Arrays.asList(configFile));
        return this.generateAll(configs, outputDir);
    }

    public int generate(List<File> configFiles, File outputDir) throws ArgumentException, IOException {
        List<Configuration> configs = this.readConfigurationFiles(configFiles);
        return this.generateAll(configs, outputDir);
    }

    public int generate(Configuration config, File outputDir) throws ArgumentException, IOException {
        return this.generateAll(Arrays.asList(config), outputDir);
    }

    public int generateAll(List<Configuration> configs, File outputDir) throws ArgumentException, IOException {
        if (outputDir == null) {
            throw new ArgumentException("No output dir was specified");
        }
        if (!outputDir.exists()) {
            if (!outputDir.mkdirs()) {
                throw new ArgumentException("Unable to crate output directory [" + outputDir + "]");
            }
            logger.info("Created output directory: " + outputDir);
        }
        if (!outputDir.isDirectory()) {
            throw new ArgumentException("Output directory [" + outputDir + "] exists but is not a directory");
        }
        if (!outputDir.canWrite()) {
            throw new ArgumentException("Output directory [" + outputDir + "] is not writable");
        }
        if (configs.isEmpty()) {
            logger.warn("No input configuration files (no stork launchers will be generated)");
            return 0;
        }
        int generated = 0;
        for (Configuration config : configs) {
            try {
                logger.info("Generating launcher for: " + config.getFile());
                this.doGenerate(config, outputDir);
                ++generated;
            }
            catch (Exception e) {
                throw new IOException("Unable to cleanly generate launcher for [" + config.getFile() + "]", e);
            }
        }
        return generated;
    }

    private static freemarker.template.Configuration getOrCreateFreemarker() throws Exception {
        if (fmconfig != null) {
            return fmconfig;
        }
        freemarker.template.Configuration cfg = new freemarker.template.Configuration();
        cfg.setClassForTemplateLoading(Generator.class, "");
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setIncompatibleImprovements(new Version(2, 3, 20));
        fmconfig = cfg;
        return fmconfig;
    }

    private void doGenerate(Configuration config, File outputDir) throws ArgumentException, Exception {
        Configuration.Platform unixLauncherGeneratedVia = null;
        File binDir = Paths.get(outputDir.getPath(), config.getBinDir()).toFile();
        File shareDir = Paths.get(outputDir.getPath(), config.getShareDir()).toFile();
        TreeSet<Configuration.Platform> sortedPlatforms = new TreeSet<Configuration.Platform>(config.getPlatforms());
        for (Configuration.Platform platform : sortedPlatforms) {
            File launcherFile;
            logger.info("Generating launcher for platform: " + (Object)((Object)platform));
            LauncherModel model = new LauncherModel(config);
            if (platform == Configuration.Platform.LINUX || platform == Configuration.Platform.MAC_OSX) {
                if (unixLauncherGeneratedVia != null) {
                    logger.info(" - launcher: same as for " + unixLauncherGeneratedVia);
                } else {
                    binDir.mkdirs();
                    launcherFile = new File(binDir, config.getName());
                    if (config.getType() == Configuration.Type.CONSOLE) {
                        this.generateUnixConsoleLauncher(config, launcherFile, model);
                    } else if (config.getType() == Configuration.Type.DAEMON) {
                        this.generateUnixDaemonLauncher(config, launcherFile, model);
                    }
                    if (config.isIncludeJavaDetectHelper()) {
                        File helperDir = new File(shareDir, "helper");
                        helperDir.mkdirs();
                        File javaDetectFile = new File(helperDir, "java-detect");
                        this.generateUnixJavaDetectScript(javaDetectFile);
                    }
                    unixLauncherGeneratedVia = platform;
                }
                if (platform == Configuration.Platform.LINUX && config.getType() == Configuration.Type.DAEMON) {
                    File initdDir = new File(shareDir, "init.d");
                    initdDir.mkdirs();
                    File initdFile = new File(initdDir, config.getName() + ".init");
                    this.generateInitdScript(config, initdFile, model);
                }
                if (platform != Configuration.Platform.MAC_OSX || config.getType() != Configuration.Type.DAEMON) continue;
                File osxDir = new File(shareDir, "osx");
                osxDir.mkdirs();
                File launchdFile = new File(osxDir, config.getDomain() + "." + config.getName() + ".plist");
                this.generateOSXLaunchdScript(config, launchdFile, model);
                continue;
            }
            if (platform == Configuration.Platform.WINDOWS) {
                if (config.getType() == Configuration.Type.CONSOLE) {
                    binDir.mkdirs();
                    launcherFile = new File(binDir, config.getName() + ".bat");
                    this.generateWindowsConsoleLauncher(config, launcherFile, model);
                    continue;
                }
                if (config.getType() != Configuration.Type.DAEMON) continue;
                Configuration.DaemonMethod dm = config.getPlatformDaemonMethod(Configuration.Platform.WINDOWS);
                if (dm == Configuration.DaemonMethod.JSLWIN) {
                    this.generateWindowsJSLWinLauncher(config, binDir, model);
                    continue;
                }
                if (dm == Configuration.DaemonMethod.WINSW) {
                    this.generateWindowsWINSWLauncher(config, binDir, model);
                    continue;
                }
                throw new ArgumentException("Unsupported daemon method [" + (Object)((Object)dm) + "] for platform WINDOWS");
            }
            throw new ArgumentException("Unsupported platform " + (Object)((Object)platform));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUnixConsoleLauncher(Configuration config, File launcherFile, LauncherModel model) throws Exception {
        FileOutputStream fos = new FileOutputStream(launcherFile);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.processTemplate("linux/script-header.ftl", out, model);
            this.includeResource("linux/script-functions.sh", fos);
            this.processTemplate("linux/script-java.ftl", out, model);
            this.processTemplate("linux/script-console.ftl", out, model);
            launcherFile.setExecutable(true);
            logger.info(" - launcher: " + launcherFile);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUnixDaemonLauncher(Configuration config, File launcherFile, LauncherModel model) throws Exception {
        FileOutputStream fos = new FileOutputStream(launcherFile);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.processTemplate("linux/script-header.ftl", out, model);
            this.includeResource("linux/script-functions.sh", fos);
            this.processTemplate("linux/script-java.ftl", out, model);
            Configuration.DaemonMethod dm = config.getPlatformDaemonMethod(Configuration.Platform.LINUX);
            if (dm != Configuration.DaemonMethod.NOHUP) {
                throw new Exception("Unsupported daemon method [" + (Object)((Object)dm) + "] for platform LINUX");
            }
            this.processTemplate("linux/script-daemon-nohup.ftl", out, model);
            launcherFile.setExecutable(true);
            logger.info(" - launcher: " + launcherFile);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateInitdScript(Configuration config, File initdFile, LauncherModel model) throws Exception {
        FileOutputStream fos = new FileOutputStream(initdFile);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.processTemplate("linux/initd-daemon.ftl", out, model);
            initdFile.setExecutable(true);
            logger.info(" - init.d: " + initdFile);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateOSXLaunchdScript(Configuration config, File launchdFile, LauncherModel model) throws Exception {
        FileOutputStream fos = new FileOutputStream(launchdFile);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.processTemplate("osx/launchd.ftl", out, model);
            logger.info(" - launchd: " + launchdFile);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateUnixJavaDetectScript(File file) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.includeResource("linux/script-java-detect-header.sh", fos);
            this.includeResource("linux/script-functions.sh", fos);
            this.includeResource("linux/script-java-detect.sh", fos);
            file.setExecutable(true);
            logger.info(" - script: " + file);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateWindowsConsoleLauncher(Configuration config, File launcherFile, LauncherModel model) throws Exception {
        FileOutputStream fos = new FileOutputStream(launcherFile);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.processTemplate("windows/batch-header.ftl", out, model);
            this.includeResource("windows/batch-find-java.bat", fos);
            this.processTemplate("windows/batch-java.ftl", out, model);
            this.processTemplate("windows/batch-console.ftl", out, model);
            this.processTemplate("windows/batch-footer.ftl", out, model);
            launcherFile.setExecutable(true);
            logger.info(" - launcher: " + launcherFile);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void generateWindowsWINSWLauncher(Configuration config, File binDir, LauncherModel model) throws Exception {
        binDir.mkdirs();
        File serviceFile = new File(binDir, config.getName() + ".exe");
        File configFile = new File(binDir, config.getName() + ".xml");
        File netFile = new File(binDir, config.getName() + ".exe.config");
        this.copyResource("windows/winsw/winsw-1.16-bin.exe", serviceFile);
        logger.info(" - launcher helper: " + serviceFile);
        this.copyResource("windows/winsw/winsw.exe.config", netFile);
        logger.info(" - launcher helper: " + serviceFile);
        this.generateWindowsWINSWConfig(config, configFile, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateWindowsWINSWConfig(Configuration config, File configFile, LauncherModel model) throws Exception {
        FileOutputStream fos = new FileOutputStream(configFile);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.processTemplate("windows/config-daemon-winsw.ftl", out, model);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateWindowsJSLWinLauncher(Configuration config, File binDir, LauncherModel model) throws Exception {
        binDir.mkdirs();
        File launcherFile = new File(binDir, config.getName() + ".bat");
        FileOutputStream fos = new FileOutputStream(launcherFile);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.processTemplate("windows/batch-header.ftl", out, model);
            this.includeResource("windows/batch-find-java.bat", fos);
            this.processTemplate("windows/batch-java.ftl", out, model);
            this.processTemplate("windows/batch-daemon-jslwin.ftl", out, model);
            this.processTemplate("windows/batch-footer.ftl", out, model);
            launcherFile.setExecutable(true);
            logger.info(" - launcher: " + launcherFile);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        File serviceFile = new File(binDir, config.getName() + "32.exe");
        File iniFile = new File(binDir, config.getName() + "32.ini");
        File service64File = new File(binDir, config.getName() + "64.exe");
        File ini64File = new File(binDir, config.getName() + "64.ini");
        this.copyResource("windows/jslwin/jsl_static.exe", serviceFile);
        logger.info(" - launcher helper: " + serviceFile);
        this.generateWindowsJSLWinINI(config, iniFile, model);
        logger.info(" - launcher helper: " + iniFile);
        this.copyResource("windows/jslwin/jsl_static64.exe", service64File);
        logger.info(" - launcher helper: " + service64File);
        this.generateWindowsJSLWinINI(config, ini64File, model);
        logger.info(" - launcher helper: " + ini64File);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateWindowsJSLWinINI(Configuration config, File iniFile, LauncherModel model) throws Exception {
        FileOutputStream fos = new FileOutputStream(iniFile);
        OutputStreamWriter out = new OutputStreamWriter(fos);
        try {
            this.processTemplate("windows/config-daemon-jslwin.ftl", out, model);
        }
        finally {
            if (out != null) {
                ((Writer)out).close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void processTemplate(String templateName, Writer out, Object model) throws Exception {
        freemarker.template.Configuration freemarker = Generator.getOrCreateFreemarker();
        Template template = freemarker.getTemplate(templateName);
        template.process(model, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String resourceName, File targetFile) throws Exception {
        FileOutputStream fos = new FileOutputStream(targetFile);
        try {
            this.includeResource(resourceName, fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private void includeResource(String resourceName, OutputStream os) throws Exception {
        int n;
        InputStream is = Generator.class.getResourceAsStream(resourceName);
        if (is == null) {
            throw new Exception("Unable to find resource " + resourceName);
        }
        byte[] buffer = new byte[1024];
        while ((n = is.read(buffer)) > -1) {
            os.write(buffer, 0, n);
        }
        is.close();
    }
}

