/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.launcher;

import com.fizzed.stork.launcher.ArgumentException;
import com.fizzed.stork.launcher.BaseApplication;
import com.fizzed.stork.launcher.Configuration;
import com.fizzed.stork.launcher.FileUtil;
import com.fizzed.stork.launcher.Generator;
import com.fizzed.stork.launcher.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratorMain
extends BaseApplication {
    private static final Logger logger = LoggerFactory.getLogger(GeneratorMain.class);

    @Override
    public void printUsage() {
        System.err.println("Usage: stork-generate -i <input config> -o <output directory> [-i ...]");
        System.err.println("-v                      Print version and exit");
        System.err.println("-i <input config>       Input file (dir or wildcard accepted)");
        System.err.println("-o <output directory>   Output directory");
    }

    public static void main(String[] args) {
        new GeneratorMain().run(args);
    }

    @Override
    public void run(String[] args) {
        if (args.length <= 0) {
            this.printErrorThenUsageAndExit("required parameters missing");
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        ArrayList<String> configFileStrings = new ArrayList<String>();
        File outputDir = null;
        while (argList.size() > 0) {
            String argSwitch = (String)argList.remove(0);
            if (argSwitch.equals("-v") || argSwitch.equals("--version")) {
                System.err.println("stork-generate: v" + Version.getLongVersion());
                System.exit(0);
                continue;
            }
            if (argSwitch.equals("-h") || argSwitch.equals("--help")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            if (argSwitch.equals("-i") || argSwitch.equals("--input")) {
                String fileString = this.popNextArg(argSwitch, argList);
                configFileStrings.add(fileString);
                continue;
            }
            if (argSwitch.equals("-o") || argSwitch.equals("--output")) {
                outputDir = new File(this.popNextArg(argSwitch, argList));
                continue;
            }
            this.printErrorThenUsageAndExit("invalid argument switch [" + argSwitch + "] found");
        }
        try {
            Generator generator = new Generator();
            List<File> configFiles = FileUtil.findAllFiles(configFileStrings, false);
            List<Configuration> configs = generator.readConfigurationFiles(configFiles);
            int generated = generator.generateAll(configs, outputDir);
            logger.info("Done (generated " + generated + " launchers)");
        }
        catch (ArgumentException e) {
            this.printErrorThenUsageAndExit(e.getMessage());
        }
        catch (IOException e) {
            logger.error("Unable to cleanly process launcher configs", (Throwable)e);
            this.printErrorThenUsageAndExit(e.getMessage());
        }
    }
}

