/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.launcher;

import com.fasterxml.jackson.databind.JsonNode;
import com.fizzed.stork.launcher.BaseApplication;
import com.fizzed.stork.launcher.ConfigurationFactory;
import com.fizzed.stork.launcher.FileUtil;
import com.fizzed.stork.launcher.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merger
extends BaseApplication {
    private static final Logger logger = LoggerFactory.getLogger(Merger.class);

    @Override
    public void printUsage() {
        System.err.println("Usage: stork-merge -i <input config> -o <output config> [-i ...]");
        System.err.println("-v                   Print version and exit");
        System.err.println("-i <input config>    Input file (dir or wildcard accepted)");
        System.err.println("-o <output config>   Output file");
    }

    public static void main(String[] args) {
        new Merger().run(args);
    }

    @Override
    public void run(String[] args) {
        if (args.length <= 0) {
            this.printErrorThenUsageAndExit("required parameters missing");
        }
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        ArrayList<File> configFiles = new ArrayList<File>();
        File outputFile = null;
        while (argList.size() > 0) {
            String argSwitch = (String)argList.remove(0);
            if (argSwitch.equals("-v") || argSwitch.equals("--version")) {
                System.err.println("stork-merge: v" + Version.getLongVersion());
                System.exit(0);
                continue;
            }
            if (argSwitch.equals("-h") || argSwitch.equals("--help")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            if (argSwitch.equals("-i") || argSwitch.equals("--input")) {
                String fileString = this.popNextArg(argSwitch, argList);
                try {
                    List<File> files = FileUtil.findFiles(fileString, false);
                    configFiles.addAll(files);
                }
                catch (IOException e) {
                    this.printErrorThenUsageAndExit(e.getMessage());
                }
                continue;
            }
            if (argSwitch.equals("-o") || argSwitch.equals("--output")) {
                outputFile = new File(this.popNextArg(argSwitch, argList));
                File outputDir = outputFile.getParentFile();
                if (!outputDir.exists()) {
                    if (!outputDir.mkdirs()) {
                        this.printErrorThenUsageAndExit("unable to make output dir [" + outputDir + "]");
                    } else {
                        System.out.println("Created output directory: " + outputDir);
                    }
                }
                if (!outputDir.isDirectory()) {
                    this.printErrorThenUsageAndExit("output dir [" + outputDir + "] exists but is not a directory");
                }
                if (outputDir.canWrite()) continue;
                this.printErrorThenUsageAndExit("output dir [" + outputDir + "] is not writable");
                continue;
            }
            this.printErrorThenUsageAndExit("invalid argument switch [" + argSwitch + "] found");
        }
        try {
            this.merge(configFiles, outputFile);
        }
        catch (IOException e) {
            logger.error("Unable to cleanly merge launcher configs", (Throwable)e);
            this.printErrorThenUsageAndExit(e.getMessage());
        }
    }

    public void merge(List<File> configFiles, File outputFile) throws IOException {
        if (configFiles == null || configFiles.isEmpty()) {
            throw new IllegalArgumentException("No input config files were found");
        }
        if (outputFile == null) {
            throw new IOException("no output file was specified");
        }
        ConfigurationFactory factory = new ConfigurationFactory();
        JsonNode mergedNode = null;
        ArrayList configs = new ArrayList();
        for (File configFile : configFiles) {
            try {
                JsonNode updateNode = factory.createConfigNode(configFile);
                if (mergedNode == null) {
                    mergedNode = updateNode;
                    continue;
                }
                mergedNode = factory.mergeNodes(mergedNode, updateNode);
            }
            catch (Exception e) {
                this.printError("config file [" + configFile + "] invalid");
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
        try {
            factory.getMapper().writeValue(outputFile, mergedNode);
            System.out.println("Wrote merged config file: " + outputFile);
        }
        catch (Exception e) {
            this.printError("Unable to cleanly write merged config");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

