/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.stork.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyFile {
    private static final Logger logger = LoggerFactory.getLogger(CopyFile.class);

    public static void main(String[] args) throws Exception {
        new CopyFile().run(args);
    }

    public String popNextArg(String argSwitch, List<String> argList) {
        if (argList.isEmpty()) {
            logger.error("argument switch [" + argSwitch + "] is missing value as next argument");
            System.exit(1);
        }
        return argList.remove(0);
    }

    public void run(String[] args) {
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        ArrayList<File> inputFiles = new ArrayList<File>();
        File outputDir = null;
        while (argList.size() > 0) {
            String fileString;
            String argSwitch = (String)argList.remove(0);
            if (argSwitch.equals("-i")) {
                fileString = this.popNextArg(argSwitch, argList);
                inputFiles.add(new File(fileString));
                continue;
            }
            if (argSwitch.equals("-o")) {
                fileString = this.popNextArg(argSwitch, argList);
                outputDir = new File(fileString);
                continue;
            }
            logger.error("invalid argument switch [" + argSwitch + "] found");
            System.exit(1);
        }
        if (inputFiles.isEmpty()) {
            logger.error("No input files provided");
            System.exit(1);
        }
        for (File inputFile : inputFiles) {
            try {
                if (inputFile.isDirectory()) {
                    File[] files;
                    for (File f : files = inputFile.listFiles()) {
                        this.copyFile(f, outputDir);
                    }
                    continue;
                }
                this.copyFile(inputFile, outputDir);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                System.exit(1);
            }
        }
    }

    public void copyFile(File inputFile, File outputDir) throws IOException {
        if (inputFile.isDirectory()) {
            File[] files = inputFile.listFiles();
            File newOutputDir = new File(outputDir, inputFile.getName());
            for (File f : files) {
                this.copyFile(f, newOutputDir);
            }
        } else {
            File outputFile = new File(outputDir, inputFile.getName());
            outputDir.mkdirs();
            logger.info(" copying " + inputFile + " to " + outputFile);
            FileUtils.copyFile((File)inputFile, (File)outputFile);
            if (inputFile.canExecute()) {
                outputFile.setExecutable(true);
            }
        }
    }
}

